/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.notifications.ConfigurationContainer;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationEventImpl<VIEWT>
implements ConfigurationNotificationEvent<VIEWT> {
    @Nullable
    private final VIEWT oldValue;
    @Nullable
    private final VIEWT newValue;
    private final long storageRevision;
    private final ConfigurationContainer tail;

    ConfigurationNotificationEventImpl(@Nullable VIEWT oldValue, @Nullable VIEWT newValue, long storageRevision, ConfigurationContainer tail) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.storageRevision = storageRevision;
        this.tail = tail;
    }

    @Nullable
    public VIEWT oldValue() {
        return this.oldValue;
    }

    @Nullable
    public <T> T oldValue(Class<T> viewClass) {
        return this.tail.find(viewClass, true);
    }

    @Nullable
    public VIEWT newValue() {
        return this.newValue;
    }

    @Nullable
    public <T> T newValue(Class<T> viewClass) {
        return this.tail.find(viewClass, false);
    }

    public long storageRevision() {
        return this.storageRevision;
    }

    @Nullable
    public String oldName(Class<?> viewClass) {
        return this.tail.name(viewClass, true);
    }

    @Nullable
    public String newName(Class<?> viewClass) {
        return this.tail.name(viewClass, false);
    }
}

