/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.BitSet;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.sql.engine.exec.ProjectedTableRowConverterImpl;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite.internal.sql.engine.exec.TableRowConverterImpl;
import org.apache.ignite.internal.sql.engine.exec.VirtualColumn;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.type.NativeTypes;
import org.jetbrains.annotations.Nullable;

public class TableRowConverterFactoryImpl
implements TableRowConverterFactory {
    private final SchemaRegistry schemaRegistry;
    private final SchemaDescriptor schemaDescriptor;
    private final BinaryTupleSchema fullTupleSchema;
    private final TableRowConverter fullRowConverter;
    private final BitSet tableColumnSet;
    private IntFunction<VirtualColumn> virtualColumnFactory;

    public TableRowConverterFactoryImpl(TableDescriptor tableDescriptor, SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor) {
        this.schemaRegistry = schemaRegistry;
        this.schemaDescriptor = schemaDescriptor;
        this.fullTupleSchema = BinaryTupleSchema.createRowSchema((SchemaDescriptor)schemaDescriptor);
        this.fullRowConverter = new TableRowConverterImpl(schemaRegistry, schemaDescriptor);
        this.tableColumnSet = new BitSet();
        this.tableColumnSet.set(0, tableDescriptor.columnsCount());
        ColumnDescriptor columnDescriptor = tableDescriptor.columnDescriptor("__part");
        if (columnDescriptor != null) {
            assert (columnDescriptor.virtual());
            this.virtualColumnFactory = partId -> new VirtualColumn(columnDescriptor.logicalIndex(), NativeTypes.INT32, false, partId);
        }
    }

    @Override
    public TableRowConverter create(@Nullable BitSet requiredColumns) {
        if (requiredColumns == null) {
            return this.fullRowConverter;
        }
        return this.create(requiredColumns, -1);
    }

    @Override
    public TableRowConverter create(@Nullable BitSet requiredColumns, int partId) {
        boolean requireVirtualColumn;
        if (requiredColumns == null) {
            requiredColumns = this.tableColumnSet;
        }
        boolean bl = requireVirtualColumn = requiredColumns.nextSetBit(this.schemaDescriptor.length()) != -1;
        if (!requireVirtualColumn && requiredColumns.cardinality() == this.schemaDescriptor.length()) {
            return this.fullRowConverter;
        }
        return new ProjectedTableRowConverterImpl(this.schemaRegistry, this.fullTupleSchema, this.schemaDescriptor, requiredColumns, requireVirtualColumn ? List.of(this.virtualColumnFactory.apply(partId)) : List.of());
    }
}

