/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.file;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongToIntFunction;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.logit.LibC;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileHeader;
import org.apache.ignite.raft.jraft.storage.logit.util.concurrent.ReferenceResource;
import org.apache.ignite.raft.jraft.util.Platform;
import org.apache.ignite.raft.jraft.util.Utils;
import sun.nio.ch.DirectBuffer;

public abstract class AbstractFile
extends ReferenceResource {
    private static final IgniteLogger LOG = Loggers.forClass(AbstractFile.class);
    public static final ByteOrder LOGIT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    protected static final int BLANK_HOLE_SIZE = 64;
    protected static final byte FILE_END_BYTE = 120;
    private final RaftOptions raftOptions;
    protected String filePath;
    protected int fileSize;
    protected File file;
    protected FileHeader header;
    protected MappedByteBuffer mappedByteBuffer;
    protected volatile int wrotePosition = 0;
    protected volatile int flushedPosition = 0;
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    private volatile boolean isMapped = false;
    private final ReentrantLock mapLock = new ReentrantLock();

    public AbstractFile(RaftOptions raftOptions, String filePath, int fileSize, boolean isMapped) {
        this.raftOptions = raftOptions;
        this.initAndMap(filePath, fileSize, isMapped);
        this.header = new FileHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAndMap(String filePath, int fileSize, boolean isMapped) {
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.file = new File(filePath);
        this.mapLock.lock();
        try {
            if (!this.file.exists() && !this.file.createNewFile()) {
                throw new RuntimeException("Failed to create new file");
            }
            if (isMapped) {
                this.map(FileChannel.MapMode.READ_WRITE);
            }
        }
        catch (Throwable t) {
            LOG.error("Error happen when create file:{}", new Object[]{filePath, t});
        }
        finally {
            this.mapLock.unlock();
        }
    }

    public void mapInIfNecessary() {
        if (!this.isMapped()) {
            this.map(FileChannel.MapMode.READ_ONLY);
        }
    }

    public void map(FileChannel.MapMode mapMode) {
        block16: {
            this.mapLock.lock();
            try {
                if (this.isMapped()) break block16;
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
                     FileChannel fileChannel = randomAccessFile.getChannel();){
                    this.mappedByteBuffer = fileChannel.map(mapMode, 0L, this.fileSize);
                    this.mappedByteBuffer.order(LOGIT_BYTE_ORDER);
                    this.isMapped = true;
                }
            }
            catch (Throwable t) {
                LOG.error("map file {} failed , {}", new Object[]{this.getFilePath(), t});
                throw new RuntimeException(t);
            }
            finally {
                this.mapLock.unlock();
            }
        }
    }

    public void unmmap() {
        if (this.isMapped()) {
            this.mapLock.lock();
            try {
                if (this.isMapped()) {
                    this.mappedByteBuffer.force();
                    this.flushedPosition = this.getWrotePosition();
                    if (this.mappedByteBuffer != null) {
                        if (Platform.isLinux()) {
                            this.hintUnload();
                        }
                        Utils.unmap(this.mappedByteBuffer);
                    }
                    this.isMapped = false;
                }
            }
            catch (Throwable t) {
                LOG.error("error unmap file {} , {}", new Object[]{this.getFilePath(), t});
                throw new RuntimeException(t);
            }
            finally {
                this.mapLock.unlock();
            }
        }
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public RecoverResult recover() {
        if (!this.loadHeader()) {
            return RecoverResult.newInstance(false, false, -1);
        }
        ByteBuffer byteBuffer = this.sliceByteBuffer();
        int recoverPosition = this.header.getHeaderSize();
        int recoverCnt = 0;
        int lastLogPosition = recoverPosition;
        boolean isFileEnd = false;
        long start = Utils.monotonicMs();
        while (true) {
            byteBuffer.position(recoverPosition);
            CheckDataResult checkResult = this.checkData(byteBuffer);
            if (checkResult == CheckDataResult.FILE_END) {
                isFileEnd = true;
                break;
            }
            if (checkResult == CheckDataResult.CHECK_FAIL) break;
            ++recoverCnt;
            lastLogPosition = recoverPosition;
            recoverPosition += checkResult.size;
        }
        this.updateAllPosition(recoverPosition);
        this.onRecoverDone(lastLogPosition);
        LOG.info("Recover file {} cost {} millis, recoverPosition:{}, recover logs:{}, lastLogIndex:{}", new Object[]{this.getFilePath(), Utils.monotonicMs() - start, recoverPosition, recoverCnt, this.getLastLogIndex()});
        boolean isRecoverTotal = isFileEnd || recoverPosition == this.fileSize;
        return RecoverResult.newInstance(true, isRecoverTotal, recoverPosition);
    }

    public abstract CheckDataResult checkData(ByteBuffer var1);

    public abstract void onRecoverDone(int var1);

    public abstract int truncate(long var1, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doAppend(long logIndex, LongToIntFunction append) {
        this.writeLock.lock();
        try {
            int wrotePos = this.getWrotePosition();
            if (this.header.isBlank()) {
                this.header.setFirstLogIndex(logIndex);
                this.saveHeader();
                wrotePos = this.header.getHeaderSize();
            }
            ByteBuffer buffer = this.sliceByteBuffer();
            long pointer = GridUnsafe.bufferAddress((ByteBuffer)buffer) + (long)wrotePos;
            int length = append.applyAsInt(pointer);
            this.setWrotePosition(wrotePos + length);
            this.header.setLastLogIndex(logIndex);
            int n = wrotePos;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int flush() {
        if (this.hold()) {
            int value = this.getWrotePosition();
            try {
                if (this.raftOptions.isSync()) {
                    this.mappedByteBuffer.force();
                }
            }
            catch (Throwable e) {
                LOG.error("Error occurred when force data to disk.", e);
                throw new RuntimeException(e);
            }
            this.setFlushPosition(value);
            this.release();
        } else {
            LOG.warn("In flush, hold failed, flush offset = {}.", new Object[]{this.getFlushedPosition()});
            this.setFlushPosition(this.getWrotePosition());
        }
        return this.getFlushedPosition();
    }

    public boolean shutdown(long intervalForcibly, boolean isDestroy) {
        this.shutdown(intervalForcibly);
        if (this.isCleanupOver()) {
            try {
                if (isDestroy) {
                    return IgniteUtils.deleteIfExists((Path)this.file.toPath());
                }
                return true;
            }
            catch (Throwable t) {
                LOG.error("Close file channel failed, {}", new Object[]{this.getFilePath(), t});
                throw new RuntimeException(t);
            }
        }
        return false;
    }

    @Override
    public boolean cleanup(long currentRef) {
        if (this.isAvailable()) {
            return false;
        }
        if (this.isCleanupOver() || !this.isMapped()) {
            return true;
        }
        this.unmmap();
        return true;
    }

    public boolean loadHeader() {
        ByteBuffer byteBuffer = this.sliceByteBuffer();
        byteBuffer.position(0);
        return this.header.decode(byteBuffer);
    }

    public void saveHeader() {
        ByteBuffer header = this.header.encode();
        ByteBuffer byteBuffer = this.sliceByteBuffer();
        byteBuffer.position(0);
        byteBuffer.put(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillEmptyBytesInFileEnd() {
        this.writeLock.lock();
        try {
            int wrotePosition = this.getWrotePosition();
            ByteBuffer byteBuffer = this.sliceByteBuffer();
            for (int i = wrotePosition; i < this.fileSize; ++i) {
                byteBuffer.put(i, (byte)120);
            }
            this.setWrotePosition(this.fileSize);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int startPos) {
        this.writeLock.lock();
        try {
            if (startPos < 0 || startPos > this.fileSize) {
                return;
            }
            int endPos = Math.min(this.fileSize, startPos + 64);
            for (int i = startPos; i < endPos; ++i) {
                this.mappedByteBuffer.put(i, (byte)0);
            }
            this.mappedByteBuffer.force();
            LOG.info("File {} cleared data in [{}, {}].", new Object[]{this.filePath, startPos, endPos});
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void put(ByteBuffer buffer, int index, byte[] data) {
        GridUnsafe.copyHeapOffheap((Object)data, (long)GridUnsafe.BYTE_ARR_OFF, (long)(GridUnsafe.bufferAddress((ByteBuffer)buffer) + (long)index), (long)data.length);
    }

    public long getFirstLogIndex() {
        return this.header.getFirstLogIndex();
    }

    public long getLastLogIndex() {
        return this.header.getLastLogIndex();
    }

    public void setLastLogIndex(long lastLogIndex) {
        this.header.setLastLogIndex(lastLogIndex);
    }

    public void setFileFromOffset(long fileFromOffset) {
        this.header.setFileFromOffset(fileFromOffset);
    }

    public long getFileFromOffset() {
        return this.header.getFileFromOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long logIndex) {
        this.readLock.lock();
        try {
            boolean bl = logIndex >= this.header.getFirstLogIndex() && logIndex <= this.getLastLogIndex();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ByteBuffer sliceByteBuffer() {
        return this.mappedByteBuffer.slice().order(LOGIT_BYTE_ORDER);
    }

    public void warmupFile() {
        if (!this.isMapped()) {
            return;
        }
        if (Platform.isLinux()) {
            this.hintLoad();
        }
    }

    public void hintLoad() {
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        long beginTime = Utils.monotonicMs();
        if (Platform.isLinux()) {
            int ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.fileSize), 3);
            LOG.info("madvise(MADV_WILLNEED) {} {} {} ret = {} time consuming = {}", new Object[]{address, this.filePath, this.fileSize, ret, Utils.monotonicMs() - beginTime});
        }
    }

    public void hintUnload() {
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        long beginTime = Utils.monotonicMs();
        if (Platform.isLinux()) {
            int ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.fileSize), 4);
            LOG.info("madvise(MADV_DONTNEED) {} {} {} ret = {} time consuming = {}", new Object[]{address, this.filePath, this.fileSize, ret, Utils.monotonicMs() - beginTime});
        }
    }

    public void reset() {
        this.setWrotePosition(0);
        this.setFlushPosition(0);
        this.header.setFirstLogIndex(-99L);
        this.flush();
    }

    public int getWrotePosition() {
        return this.wrotePosition;
    }

    public void setWrotePosition(int position) {
        this.wrotePosition = position;
    }

    public int getFlushedPosition() {
        return this.flushedPosition;
    }

    public void setFlushPosition(int position) {
        this.flushedPosition = position;
    }

    public void updateAllPosition(int pos) {
        this.setWrotePosition(pos);
        this.setFlushPosition(pos);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean reachesFileEndBy(int waitToWroteSize) {
        return this.getWrotePosition() + waitToWroteSize > this.getFileSize();
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public boolean isBlank() {
        return this.header.isBlank();
    }

    public static class RecoverResult {
        private final boolean recoverSuccess;
        private final boolean recoverTotal;
        private final int lastOffset;

        public RecoverResult(boolean recoverSuccess, boolean recoverTotal, int lastOffset) {
            this.recoverSuccess = recoverSuccess;
            this.recoverTotal = recoverTotal;
            this.lastOffset = lastOffset;
        }

        public static RecoverResult newInstance(boolean isSuccess, boolean isRecoverTotal, int recoverOffset) {
            return new RecoverResult(isSuccess, isRecoverTotal, recoverOffset);
        }

        public int getLastOffset() {
            return this.lastOffset;
        }

        public boolean recoverSuccess() {
            return this.recoverSuccess;
        }

        public boolean recoverTotal() {
            return this.recoverTotal;
        }
    }

    public static class CheckDataResult {
        public static final CheckDataResult CHECK_FAIL = new CheckDataResult(-1);
        public static final CheckDataResult FILE_END = new CheckDataResult(0);
        private int size;

        public CheckDataResult(int pos) {
            this.size = pos;
        }
    }
}

