/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.node.metric;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.node.metric.NodeMetricSourceListCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.node.NodeUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.decorators.MetricSourceListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Lists node metric sources"})
public class NodeMetricSourceListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private NodeUrlMixin nodeUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private NodeMetricSourceListCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.nodeUrl.getNodeUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list metric sources")).print(new MetricSourceListDecorator(this.plain)));
    }
}

