/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import com.google.auto.service.AutoService;
import java.nio.file.Path;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite.internal.configuration.SystemLocalExtensionConfiguration;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.engine.StorageEngine;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryStorageEngine;
import org.jetbrains.annotations.Nullable;

@AutoService(value={DataStorageModule.class})
public class PersistentPageMemoryDataStorageModule
implements DataStorageModule {
    public String name() {
        return "aipersist";
    }

    public StorageEngine createEngine(String igniteInstanceName, MetricManager metricManager, ConfigurationRegistry configRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, HybridClock clock, ScheduledExecutorService commonScheduler) throws StorageException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)configRegistry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        SystemLocalConfiguration systemLocalConfig = ((SystemLocalExtensionConfiguration)configRegistry.getConfiguration(SystemLocalExtensionConfiguration.KEY)).system();
        PageIoRegistry ioRegistry = new PageIoRegistry();
        ioRegistry.loadFromServiceLoader();
        return new PersistentPageMemoryStorageEngine(igniteInstanceName, metricManager, storageConfig, systemLocalConfig, ioRegistry, storagePath, longJvmPauseDetector, failureManager, logSyncer, commonScheduler, clock);
    }
}

