/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.config;

import java.io.File;
import java.nio.file.Path;

public final class ConfigConstants {
    private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private static final String PARENT_FOLDER_NAME = "ignitecli";
    private static final String CONFIG_FILE_NAME = "defaults";
    private static final String SECRET_CONFIG_FILE_NAME = "secrets";
    private static final String IGNITE_CLI_CONFIG_FILE = "IGNITE_CLI_CONFIG_FILE";
    private static final String IGNITE_CLI_SECRET_CONFIG_FILE = "IGNITE_CLI_SECRET_CONFIG_FILE";
    public static final String IGNITE_CLI_LOGS_DIR = "IGNITE_CLI_LOGS_DIR";
    public static final String CURRENT_PROFILE = "current_profile";

    private ConfigConstants() {
    }

    public static File getConfigFile() {
        String configFile = System.getenv(IGNITE_CLI_CONFIG_FILE);
        if (configFile != null) {
            return new File(configFile);
        }
        return ConfigConstants.getConfigRoot().resolve(PARENT_FOLDER_NAME).resolve(CONFIG_FILE_NAME).toFile();
    }

    public static File getSecretConfigFile() {
        String configFile = System.getenv(IGNITE_CLI_SECRET_CONFIG_FILE);
        if (configFile != null) {
            return new File(configFile);
        }
        return ConfigConstants.getConfigRoot().resolve(PARENT_FOLDER_NAME).resolve(SECRET_CONFIG_FILE_NAME).toFile();
    }

    private static Path getConfigRoot() {
        String xdgConfigHome = System.getenv(XDG_CONFIG_HOME);
        if (xdgConfigHome != null) {
            return Path.of(xdgConfigHome, new String[0]);
        }
        return Path.of(System.getProperty("user.home"), ".config");
    }
}

