/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.lang.IgniteAsyncSupport;
import org.apache.ignite.lang.IgniteFuture;

public class AsyncSupportAdapter<T extends IgniteAsyncSupport>
implements IgniteAsyncSupport {
    protected ThreadLocal<IgniteFuture<?>> curFut;

    public AsyncSupportAdapter() {
    }

    public AsyncSupportAdapter(boolean async) {
        if (async) {
            this.curFut = new ThreadLocal();
        }
    }

    public T withAsync() {
        if (this.isAsync()) {
            return (T)this;
        }
        return this.createAsyncInstance();
    }

    protected T createAsyncInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAsync() {
        return this.curFut != null;
    }

    @Override
    public <R> IgniteFuture<R> future() {
        return this.future(true);
    }

    public <R> IgniteFuture<R> future(boolean reset) {
        if (this.curFut == null) {
            throw new IllegalStateException("Asynchronous mode is disabled.");
        }
        IgniteFuture<?> fut = this.curFut.get();
        if (fut == null) {
            throw new IllegalStateException("Asynchronous operation not started.");
        }
        if (reset) {
            this.curFut.set(null);
        }
        return fut;
    }

    public <R> R saveOrGet(IgniteInternalFuture<R> fut) throws IgniteCheckedException {
        if (this.curFut != null) {
            this.curFut.set(this.createFuture(fut));
            return null;
        }
        return fut.get();
    }

    protected <R> IgniteFuture<R> createFuture(IgniteInternalFuture<R> fut) {
        return new IgniteFutureImpl<R>(fut);
    }
}

