/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public enum GridTopic {
    TOPIC_JOB,
    TOPIC_JOB_SIBLINGS,
    TOPIC_TASK,
    TOPIC_CHECKPOINT,
    TOPIC_JOB_CANCEL,
    TOPIC_TASK_CANCEL,
    TOPIC_CLASSLOAD,
    TOPIC_EVENT,
    TOPIC_CACHE,
    TOPIC_COMM_USER,
    TOPIC_REST,
    TOPIC_REPLICATION,
    TOPIC_IGFS,
    TOPIC_DATASTREAM,
    TOPIC_STREAM,
    TOPIC_CONTINUOUS,
    TOPIC_MONGO,
    TOPIC_TIME_SYNC,
    TOPIC_HADOOP,
    TOPIC_QUERY,
    TOPIC_TX,
    TOPIC_SNAPSHOT,
    TOPIC_IO_TEST,
    TOPIC_MAPPING_MARSH,
    TOPIC_HADOOP_MSG,
    TOPIC_METADATA_REQ,
    TOPIC_SCHEMA,
    TOPIC_INTERNAL_DIAGNOSTIC,
    TOPIC_WAL,
    TOPIC_METRICS,
    TOPIC_AUTH,
    TOPIC_EXCHANGE,
    TOPIC_CACHE_COORDINATOR,
    TOPIC_GEN_ENC_KEY,
    TOPIC_SERVICES,
    TOPIC_DEADLOCK_DETECTION,
    TOPIC_DISTRIBUTED_PROCESS,
    TOPIC_COMM_SYSTEM;

    private static final GridTopic[] VALS;
    private static final Charset DFLT_CHARSET;

    @Nullable
    public static GridTopic fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public Object topic(IgniteUuid id) {
        return new T1(this, id);
    }

    public Object topic(IgniteUuid id1, UUID id2) {
        return new T2(this, id1, id2);
    }

    public Object topic(IgniteUuid id1, long id2) {
        return new T8(this, id1, id2);
    }

    public Object topic(String id) {
        return new T3(this, UUID.nameUUIDFromBytes(id.getBytes(DFLT_CHARSET)));
    }

    public Object topic(String id1, long id2) {
        return new T6(this, UUID.nameUUIDFromBytes(id1.getBytes(DFLT_CHARSET)), id2);
    }

    public Object topic(String id1, int id2, long id3) {
        return new T5(this, UUID.nameUUIDFromBytes(id1.getBytes(DFLT_CHARSET)), id2, id3);
    }

    public Object topic(String id1, UUID id2, long id3) {
        return new T4(this, UUID.nameUUIDFromBytes(id1.getBytes(DFLT_CHARSET)), id2, id3);
    }

    public Object topic(String id1, UUID id2, int id3, long id4) {
        return new T7(this, UUID.nameUUIDFromBytes(id1.getBytes(DFLT_CHARSET)), id2, id3, id4);
    }

    static {
        VALS = GridTopic.values();
        DFLT_CHARSET = Charset.forName("UTF-8");
    }

    private static class T8
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private IgniteUuid id1;
        private long id2;

        public T8() {
        }

        private T8(GridTopic topic, IgniteUuid id1, long id2) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + (int)(this.id2 ^ this.id2 >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T8.class) {
                T8 that = (T8)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2 == that.id2;
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeIgniteUuid(out, this.id1);
            out.writeLong(this.id2);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readIgniteUuid(in);
            this.id2 = in.readLong();
        }

        public String toString() {
            return S.toString(T8.class, this);
        }
    }

    private static class T7
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private UUID id1;
        private UUID id2;
        private int id3;
        private long id4;

        public T7() {
        }

        private T7(GridTopic topic, UUID id1, UUID id2, int id3, long id4) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
            this.id3 = id3;
            this.id4 = id4;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + this.id2.hashCode() + this.id3 + (int)(this.id4 ^ this.id4 >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T7.class) {
                T7 that = (T7)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2.equals(that.id2) && this.id3 == that.id3 && this.id4 == that.id4;
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeUuid(out, this.id1);
            U.writeUuid(out, this.id2);
            out.writeInt(this.id3);
            out.writeLong(this.id4);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readUuid(in);
            this.id2 = U.readUuid(in);
            this.id3 = in.readInt();
            this.id4 = in.readLong();
        }

        public String toString() {
            return S.toString(T7.class, this);
        }
    }

    private static class T6
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private UUID id1;
        private long id2;

        public T6() {
        }

        private T6(GridTopic topic, UUID id1, long id2) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + (int)(this.id2 ^ this.id2 >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T6.class) {
                T6 that = (T6)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2 == that.id2;
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeUuid(out, this.id1);
            out.writeLong(this.id2);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readUuid(in);
            this.id2 = in.readLong();
        }

        public String toString() {
            return S.toString(T6.class, this);
        }
    }

    private static class T5
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private UUID id1;
        private int id2;
        private long id3;

        public T5() {
        }

        private T5(GridTopic topic, UUID id1, int id2, long id3) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
            this.id3 = id3;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + this.id2 + (int)(this.id3 ^ this.id3 >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T5.class) {
                T5 that = (T5)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2 == that.id2 && this.id3 == that.id3;
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeUuid(out, this.id1);
            out.writeInt(this.id2);
            out.writeLong(this.id3);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readUuid(in);
            this.id2 = in.readInt();
            this.id3 = in.readLong();
        }

        public String toString() {
            return S.toString(T5.class, this);
        }
    }

    private static class T4
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private UUID id1;
        private UUID id2;
        private long id3;

        public T4() {
        }

        private T4(GridTopic topic, UUID id1, UUID id2, long id3) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
            this.id3 = id3;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + this.id2.hashCode() + (int)(this.id3 ^ this.id3 >>> 32);
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T4.class) {
                T4 that = (T4)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2.equals(that.id2) && this.id3 == that.id3;
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeUuid(out, this.id1);
            U.writeUuid(out, this.id2);
            out.writeLong(this.id3);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readUuid(in);
            this.id2 = U.readUuid(in);
            this.id3 = in.readLong();
        }

        public String toString() {
            return S.toString(T4.class, this);
        }
    }

    private static class T3
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private UUID id1;

        public T3() {
        }

        private T3(GridTopic topic, UUID id1) {
            this.topic = topic;
            this.id1 = id1;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T3.class) {
                T3 that = (T3)obj;
                return this.topic == that.topic && this.id1.equals(that.id1);
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeUuid(out, this.id1);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readUuid(in);
        }

        public String toString() {
            return S.toString(T3.class, this);
        }
    }

    private static class T2
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private IgniteUuid id1;
        private UUID id2;

        public T2() {
        }

        private T2(GridTopic topic, IgniteUuid id1, UUID id2) {
            this.topic = topic;
            this.id1 = id1;
            this.id2 = id2;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id1.hashCode() + this.id2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T2.class) {
                T2 that = (T2)obj;
                return this.topic == that.topic && this.id1.equals(that.id1) && this.id2.equals(that.id2);
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeIgniteUuid(out, this.id1);
            U.writeUuid(out, this.id2);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id1 = U.readIgniteUuid(in);
            this.id2 = U.readUuid(in);
        }

        public String toString() {
            return S.toString(T2.class, this);
        }
    }

    private static class T1
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private GridTopic topic;
        private IgniteUuid id;

        public T1() {
        }

        private T1(GridTopic topic, IgniteUuid id) {
            this.topic = topic;
            this.id = id;
        }

        public int hashCode() {
            return this.topic.ordinal() + this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() == T1.class) {
                T1 that = (T1)obj;
                return this.topic == that.topic && this.id.equals(that.id);
            }
            return false;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.topic.ordinal());
            U.writeIgniteUuid(out, this.id);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.topic = GridTopic.fromOrdinal(in.readByte());
            this.id = U.readIgniteUuid(in);
        }

        public String toString() {
            return S.toString(T1.class, this);
        }
    }
}

