/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log;

import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTracker;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.log.PageLockLogSnapshot;

public class LockLog
extends PageLockTracker<PageLockLogSnapshot> {
    protected int headIdx;

    public LockLog(String name, PageMetaInfoStore pageMetaInfoStore, PageLockTrackerManager.MemoryCalculator memCalc) {
        super(name, pageMetaInfoStore, memCalc);
    }

    @Override
    public void onWriteLock0(int structureId, long pageId, long page, long pageAddr) {
        this.log(3, structureId, pageId, page, pageAddr);
    }

    @Override
    public void onWriteUnlock0(int structureId, long pageId, long page, long pageAddr) {
        this.log(4, structureId, pageId, page, pageAddr);
    }

    @Override
    public void onReadLock0(int structureId, long pageId, long page, long pageAddr) {
        this.log(1, structureId, pageId, page, pageAddr);
    }

    @Override
    public void onReadUnlock0(int structureId, long pageId, long page, long pageAddr) {
        this.log(2, structureId, pageId, page, pageAddr);
    }

    private void log(int op, int structureId, long pageId, long pageAddrHeader, long pageAddr) {
        if (!this.validateOperation(structureId, pageId, op)) {
            return;
        }
        if (this.headIdx + 1 > this.pages.capacity()) {
            this.invalid("Log overflow, size:" + this.pages.capacity() + ", headIdx=" + this.headIdx + " " + LockLog.argsToString(structureId, pageId, op));
            return;
        }
        long pageId0 = this.pages.getPageId(this.headIdx);
        if (pageId0 != 0L && pageId0 != pageId) {
            this.invalid("Head should be empty, headIdx=" + this.headIdx + " " + LockLog.argsToString(structureId, pageId, op));
            return;
        }
        if (1 == op || 3 == op) {
            ++this.heldLockCnt;
        }
        if (2 == op || 4 == op) {
            --this.heldLockCnt;
        }
        int curIdx = this.heldLockCnt << 16 & 0xFFFF0000;
        this.pages.add(this.headIdx, curIdx | op, structureId, pageId, pageAddrHeader, pageAddr);
        if (5 == op || 6 == op) {
            return;
        }
        ++this.headIdx;
        if (this.heldLockCnt == 0) {
            this.reset();
        }
        if (op != 5 && op != 6 && this.nextOpPageId == pageId && this.nextOpStructureId == structureId) {
            this.nextOpStructureId = 0;
            this.nextOpPageId = 0L;
            this.nextOp = 0;
        }
    }

    private void reset() {
        for (int itemIdx = 0; itemIdx < this.headIdx; ++itemIdx) {
            this.pages.remove(itemIdx);
        }
        this.headIdx = 0;
    }

    @Override
    public PageLockLogSnapshot snapshot() {
        PageMetaInfoStore log = this.pages.copy();
        return new PageLockLogSnapshot(this.name, System.currentTimeMillis(), this.headIdx, log, this.nextOp, this.nextOpStructureId, this.nextOpPageId);
    }
}

