/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.platform.PlatformBootstrap;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.platform.memory.PlatformExternalMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformAbstractBootstrap
implements PlatformBootstrap {
    @Override
    public PlatformProcessor start(IgniteConfiguration cfg, @Nullable GridSpringResourceContext springCtx, long envPtr) {
        IgniteConfiguration cfg0 = this.closure(envPtr).apply(cfg);
        try {
            IgniteEx node = (IgniteEx)IgnitionEx.start(cfg0, springCtx);
            return node.context().platform();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void init(long dataPtr) {
        PlatformInputStream input = new PlatformExternalMemory(null, dataPtr).input();
        Ignition.setClientMode(input.readBoolean());
        this.processInput(input);
    }

    protected abstract IgniteClosure<IgniteConfiguration, IgniteConfiguration> closure(long var1);

    protected void processInput(PlatformInputStream input) {
    }
}

