/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.Serializable;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.F;

public class HostAndPortRange
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String host;
    private final int portFrom;
    private final int portTo;

    public static HostAndPortRange parse(String addrStr, int dfltPortFrom, int dfltPortTo, String errMsgPrefix) throws IgniteCheckedException {
        int portTo;
        int portFrom;
        String host;
        assert (dfltPortFrom <= dfltPortTo);
        if (F.isEmpty(addrStr)) {
            throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "Address is empty");
        }
        if (addrStr.charAt(0) == '[') {
            int hostEndIdx = addrStr.indexOf(93);
            if (hostEndIdx == -1) {
                throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "Failed to parse IPv6 address, missing ']'");
            }
            host = addrStr.substring(1, hostEndIdx);
            if (hostEndIdx == addrStr.length() - 1) {
                portFrom = dfltPortFrom;
                portTo = dfltPortTo;
            } else {
                String portStr = addrStr.substring(hostEndIdx + 2);
                int[] ports = HostAndPortRange.verifyPortStr(addrStr, errMsgPrefix, portStr);
                portFrom = ports[0];
                portTo = ports[1];
            }
        } else {
            int colIdx = addrStr.lastIndexOf(58);
            if (colIdx > 0) {
                if (addrStr.lastIndexOf(58, colIdx - 1) != -1) {
                    try {
                        Inet6Address.getByName(addrStr);
                        host = addrStr;
                        portFrom = dfltPortFrom;
                        portTo = dfltPortTo;
                    }
                    catch (UnknownHostException e) {
                        throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "IPv6 is incorrect", e);
                    }
                } else {
                    host = addrStr.substring(0, colIdx);
                    String portStr = addrStr.substring(colIdx + 1);
                    int[] ports = HostAndPortRange.verifyPortStr(addrStr, errMsgPrefix, portStr);
                    portFrom = ports[0];
                    portTo = ports[1];
                }
            } else {
                if (colIdx == 0) {
                    throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "Host name is empty");
                }
                host = addrStr;
                portFrom = dfltPortFrom;
                portTo = dfltPortTo;
            }
        }
        return new HostAndPortRange(host, portFrom, portTo);
    }

    private static int[] verifyPortStr(String addrStr, String errMsgPrefix, String portStr) throws IgniteCheckedException {
        String portToStr;
        String portFromStr;
        if (F.isEmpty(portStr)) {
            throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "port range is not specified");
        }
        int portRangeIdx = portStr.indexOf("..");
        if (portRangeIdx >= 0) {
            portFromStr = portStr.substring(0, portRangeIdx);
            portToStr = portStr.substring(portRangeIdx + 2);
        } else {
            portFromStr = portStr;
            portToStr = portStr;
        }
        int portFrom = HostAndPortRange.parsePort(portFromStr, addrStr, errMsgPrefix);
        int portTo = HostAndPortRange.parsePort(portToStr, addrStr, errMsgPrefix);
        if (portFrom > portTo) {
            throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "start port cannot be less than end port");
        }
        return new int[]{portFrom, portTo};
    }

    private static int parsePort(String portStr, String addrStr, String errMsgPrefix) throws IgniteCheckedException {
        try {
            int port = Integer.parseInt(portStr);
            if (port <= 0 || port > 65535) {
                throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "port range contains invalid port " + portStr);
            }
            return port;
        }
        catch (NumberFormatException ignored) {
            throw HostAndPortRange.createParseError(addrStr, errMsgPrefix, "port range contains invalid port " + portStr);
        }
    }

    private static IgniteCheckedException createParseError(String addrStr, String errMsgPrefix, String errMsg) {
        return new IgniteCheckedException(errMsgPrefix + " (" + errMsg + "): " + addrStr);
    }

    private static IgniteCheckedException createParseError(String addrStr, String errMsgPrefix, String errMsg, Throwable cause) {
        return new IgniteCheckedException(errMsgPrefix + " (" + errMsg + "): " + addrStr, cause);
    }

    public HostAndPortRange(String host, int port) {
        this(host, port, port);
    }

    public HostAndPortRange(String host, int portFrom, int portTo) {
        assert (!F.isEmpty(host));
        assert (portFrom <= portTo);
        this.host = host;
        this.portFrom = portFrom;
        this.portTo = portTo;
    }

    public String host() {
        return this.host;
    }

    public int portFrom() {
        return this.portFrom;
    }

    public int portTo() {
        return this.portTo;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof HostAndPortRange) {
            HostAndPortRange other = (HostAndPortRange)o;
            return F.eq(this.host, other.host) && this.portFrom == other.portFrom && this.portTo == other.portTo;
        }
        return false;
    }

    public int hashCode() {
        int res = this.host.hashCode();
        res = 31 * res + this.portFrom;
        res = 31 * res + this.portTo;
        return res;
    }

    public String toString() {
        return this.host + ":" + (this.portFrom == this.portTo ? Integer.valueOf(this.portFrom) : this.portFrom + ".." + this.portTo);
    }
}

