/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.distributed;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class SingleNodeMessage<R extends Serializable>
implements Message {
    private static final long serialVersionUID = 0L;
    public static final short TYPE_CODE = 176;
    private UUID processId;
    private int type;
    private R resp;
    private Exception err;

    public SingleNodeMessage() {
    }

    public SingleNodeMessage(UUID processId, DistributedProcess.DistributedProcessType type, R resp, Exception err) {
        this.processId = processId;
        this.type = type.ordinal();
        this.resp = resp;
        this.err = err;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeUuid("processId", this.processId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("type", this.type)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeByteArray("data", U.toBytes(this.resp))) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("err", U.toBytes(this.err))) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.processId = reader.readUuid("processId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.type = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.resp = (Serializable)U.fromBytes(reader.readByteArray("data"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.err = (Exception)U.fromBytes(reader.readByteArray("err"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SingleNodeMessage.class);
    }

    @Override
    public short directType() {
        return 176;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void onAckReceived() {
    }

    public UUID processId() {
        return this.processId;
    }

    public int type() {
        return this.type;
    }

    public R response() {
        return this.resp;
    }

    public boolean hasError() {
        return this.err != null;
    }

    public Exception error() {
        return this.err;
    }
}

