/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.baseline;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.baseline.VisorBaselineAutoAdjustSettings;
import org.apache.ignite.internal.visor.baseline.VisorBaselineOperation;

public class VisorBaselineTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private VisorBaselineOperation op;
    private long topVer;
    private List<String> consistentIds;
    private VisorBaselineAutoAdjustSettings autoAdjustSettings;

    public VisorBaselineTaskArg() {
    }

    public VisorBaselineTaskArg(VisorBaselineOperation op, long topVer, List<String> consistentIds, VisorBaselineAutoAdjustSettings autoAdjustSettings) {
        this.op = op;
        this.topVer = topVer;
        this.consistentIds = consistentIds;
        this.autoAdjustSettings = autoAdjustSettings;
    }

    public VisorBaselineOperation getOperation() {
        return this.op;
    }

    public long getTopologyVersion() {
        return this.topVer;
    }

    public List<String> getConsistentIds() {
        return this.consistentIds;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    public VisorBaselineAutoAdjustSettings getAutoAdjustSettings() {
        return this.autoAdjustSettings;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.op);
        out.writeLong(this.topVer);
        U.writeCollection(out, this.consistentIds);
        out.writeObject(this.autoAdjustSettings);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.op = VisorBaselineOperation.fromOrdinal(in.readByte());
        this.topVer = in.readLong();
        this.consistentIds = U.readList(in);
        if (protoVer > 1) {
            this.autoAdjustSettings = (VisorBaselineAutoAdjustSettings)in.readObject();
        }
    }

    public String toString() {
        return S.toString(VisorBaselineTaskArg.class, this);
    }
}

