/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;

public class DefaultKeyedFile
implements PrimaryKeyedFile,
Serializable {
    private final DataFile internalFile;
    private final FileMeta meta;

    private DefaultKeyedFile(DataFile internalFile, FileMeta meta) {
        this.internalFile = internalFile;
        this.meta = meta;
    }

    public static DefaultKeyedFile parseChange(DataFile dataFile) {
        FileMeta fileMeta = FileNameRules.parseChange(dataFile.path().toString(), dataFile.dataSequenceNumber());
        return new DefaultKeyedFile(dataFile, fileMeta);
    }

    public static DefaultKeyedFile parseBase(DataFile dataFile) {
        FileMeta fileMeta = FileNameRules.parseBase(dataFile.path().toString());
        return new DefaultKeyedFile(dataFile, fileMeta);
    }

    @Override
    public Long transactionId() {
        return this.meta.transactionId();
    }

    @Override
    public DataFileType type() {
        return this.meta.type();
    }

    public Long pos() {
        return this.internalFile.pos();
    }

    public int specId() {
        return this.internalFile.specId();
    }

    public CharSequence path() {
        return this.internalFile.path();
    }

    public FileFormat format() {
        return this.internalFile.format();
    }

    public long recordCount() {
        return this.internalFile.recordCount();
    }

    public long fileSizeInBytes() {
        return this.internalFile.fileSizeInBytes();
    }

    public Map<Integer, Long> columnSizes() {
        return this.internalFile.columnSizes();
    }

    public Map<Integer, Long> valueCounts() {
        return this.internalFile.valueCounts();
    }

    public Map<Integer, Long> nullValueCounts() {
        return this.internalFile.nullValueCounts();
    }

    public Map<Integer, Long> nanValueCounts() {
        return this.internalFile.nanValueCounts();
    }

    public Map<Integer, ByteBuffer> lowerBounds() {
        return this.internalFile.lowerBounds();
    }

    public Map<Integer, ByteBuffer> upperBounds() {
        return this.internalFile.upperBounds();
    }

    public ByteBuffer keyMetadata() {
        return this.internalFile.keyMetadata();
    }

    public List<Long> splitOffsets() {
        return this.internalFile.splitOffsets();
    }

    public DataFile copy() {
        return new DefaultKeyedFile((DataFile)this.internalFile.copy(), this.meta);
    }

    public DataFile copyWithoutStats() {
        return new DefaultKeyedFile((DataFile)this.internalFile.copyWithoutStats(), this.meta);
    }

    public StructLike partition() {
        return this.internalFile.partition();
    }

    @Override
    public DataTreeNode node() {
        return this.meta.node();
    }

    public Long dataSequenceNumber() {
        return this.internalFile.dataSequenceNumber();
    }

    public Long fileSequenceNumber() {
        return this.internalFile.dataSequenceNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultKeyedFile that = (DefaultKeyedFile)o;
        return Objects.equals(this.internalFile.path(), that.internalFile.path());
    }

    public int hashCode() {
        return Objects.hash(this.internalFile.path());
    }

    public static class FileMeta
    implements Serializable {
        private final long transactionId;
        private final DataFileType type;
        private final DataTreeNode node;

        public FileMeta(long transactionId, DataFileType type, DataTreeNode node) {
            this.transactionId = transactionId;
            this.type = type;
            this.node = node;
        }

        public long transactionId() {
            return this.transactionId;
        }

        public DataFileType type() {
            return this.type;
        }

        public DataTreeNode node() {
            return this.node;
        }
    }
}

