/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.mixed;

import java.util.Optional;
import org.apache.amoro.TableSnapshot;
import org.apache.amoro.shade.guava32.com.google.common.primitives.Longs;
import org.apache.iceberg.Snapshot;

public class MixedSnapshot
implements TableSnapshot {
    private final Snapshot changeSnapshot;
    private final Snapshot baseSnapshot;

    public MixedSnapshot(Snapshot changeSnapshot, Snapshot baseSnapshot) {
        this.changeSnapshot = changeSnapshot;
        this.baseSnapshot = baseSnapshot;
    }

    @Override
    public long watermark() {
        return -1L;
    }

    @Override
    public long commitTime() {
        Long changCommit = Optional.ofNullable(this.changeSnapshot).map(Snapshot::timestampMillis).orElse(-1L);
        Long baseCommit = Optional.ofNullable(this.baseSnapshot).map(Snapshot::timestampMillis).orElse(-1L);
        return Longs.max((long[])new long[]{changCommit, baseCommit});
    }

    public Snapshot getChangeSnapshot() {
        return this.changeSnapshot;
    }

    public Snapshot getBaseSnapshot() {
        return this.baseSnapshot;
    }

    public long getChangeSnapshotId() {
        return Optional.ofNullable(this.changeSnapshot).map(Snapshot::snapshotId).orElse(-1L);
    }

    public long getBaseSnapshotId() {
        return Optional.ofNullable(this.baseSnapshot).map(Snapshot::snapshotId).orElse(-1L);
    }

    @Override
    public String id() {
        return this.changeSnapshot + "_" + this.baseSnapshot;
    }
}

