/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.reader.DataReaderCommon;
import org.apache.amoro.io.reader.MixedDeleteFilter;
import org.apache.amoro.scan.KeyedTableScanTask;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public abstract class AbstractKeyedDataReader<T>
implements Serializable {
    protected final AuthenticatedFileIO fileIO;
    protected final Schema tableSchema;
    protected final Schema projectedSchema;
    protected final String nameMapping;
    protected final boolean caseSensitive;
    protected final Set<DataTreeNode> sourceNodes;
    protected final BiFunction<Type, Object, Object> convertConstant;
    protected final PrimaryKeySpec primaryKeySpec;
    protected final boolean reuseContainer;
    protected StructLikeCollections structLikeCollections = StructLikeCollections.DEFAULT;

    public AbstractKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer, StructLikeCollections structLikeCollections) {
        this(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, sourceNodes, reuseContainer);
        this.structLikeCollections = structLikeCollections;
    }

    public AbstractKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, boolean reuseContainer) {
        this(fileIO, tableSchema, projectedSchema, primaryKeySpec, nameMapping, caseSensitive, convertConstant, null, reuseContainer);
    }

    public AbstractKeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer) {
        this.fileIO = fileIO;
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.primaryKeySpec = primaryKeySpec;
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        this.convertConstant = convertConstant;
        this.sourceNodes = sourceNodes != null ? Collections.unmodifiableSet(sourceNodes) : null;
        this.reuseContainer = reuseContainer;
    }

    public CloseableIterator<T> readData(KeyedTableScanTask keyedTableScanTask) {
        MixedDeleteFilter<T> mixedDeleteFilter = this.createMixedDeleteFilter(keyedTableScanTask, this.tableSchema, this.projectedSchema, this.primaryKeySpec, this.sourceNodes, this.structLikeCollections);
        Schema newProjectedSchema = mixedDeleteFilter.requiredSchema();
        CloseableIterable<T> dataIterable = mixedDeleteFilter.filter(CloseableIterable.concat((Iterable)CloseableIterable.transform((CloseableIterable)CloseableIterable.withNoopClose(keyedTableScanTask.dataTasks()), fileScanTask -> {
            switch (fileScanTask.file().format()) {
                case PARQUET: {
                    return this.newParquetIterable((FileScanTask)fileScanTask, newProjectedSchema, DataReaderCommon.getIdToConstant(fileScanTask, newProjectedSchema, this.convertConstant));
                }
                case ORC: {
                    return this.newOrcIterable((FileScanTask)fileScanTask, newProjectedSchema, DataReaderCommon.getIdToConstant(fileScanTask, newProjectedSchema, this.convertConstant));
                }
            }
            throw new UnsupportedOperationException("Cannot read unknown format: " + fileScanTask.file().format());
        })));
        return dataIterable.iterator();
    }

    public CloseableIterator<T> readDeletedData(KeyedTableScanTask keyedTableScanTask) {
        boolean hasDeleteFile;
        boolean bl = hasDeleteFile = keyedTableScanTask.mixedEquityDeletes().size() > 0 || keyedTableScanTask.dataTasks().stream().anyMatch(mixedFileScanTask -> mixedFileScanTask.deletes().size() > 0);
        if (hasDeleteFile) {
            MixedDeleteFilter<T> mixedDeleteFilter = this.createMixedDeleteFilter(keyedTableScanTask, this.tableSchema, this.projectedSchema, this.primaryKeySpec, this.sourceNodes, this.structLikeCollections);
            Schema newProjectedSchema = mixedDeleteFilter.requiredSchema();
            CloseableIterable<T> dataIterable = mixedDeleteFilter.filterNegate(CloseableIterable.concat((Iterable)CloseableIterable.transform((CloseableIterable)CloseableIterable.withNoopClose(keyedTableScanTask.dataTasks()), fileScanTask -> {
                switch (fileScanTask.file().format()) {
                    case PARQUET: {
                        return this.newParquetIterable((FileScanTask)fileScanTask, newProjectedSchema, DataReaderCommon.getIdToConstant(fileScanTask, newProjectedSchema, this.convertConstant));
                    }
                    case ORC: {
                        return this.newOrcIterable((FileScanTask)fileScanTask, newProjectedSchema, DataReaderCommon.getIdToConstant(fileScanTask, newProjectedSchema, this.convertConstant));
                    }
                }
                throw new UnsupportedOperationException("Cannot read unknown format: " + fileScanTask.file().format());
            })));
            return dataIterable.iterator();
        }
        return CloseableIterator.empty();
    }

    protected MixedDeleteFilter<T> createMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes, StructLikeCollections structLikeCollections) {
        return new GenericMixedDeleteFilter(keyedTableScanTask, tableSchema, projectedSchema, primaryKeySpec, sourceNodes, structLikeCollections);
    }

    protected CloseableIterable<T> newParquetIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Parquet.ReadBuilder builder = Parquet.read((InputFile)this.fileIO.newInputFile(((DataFile)task.file()).path().toString())).split(task.start(), task.length()).project(schema).createReaderFunc(this.getParquetReaderFunction(schema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.reuseContainer) {
            builder.reuseContainers();
        }
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
        }
        return this.fileIO.doAs(() -> ((Parquet.ReadBuilder)builder).build());
    }

    protected CloseableIterable<T> newOrcIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Schema readSchemaWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)schema, (Set)Sets.union(idToConstant.keySet(), (Set)MetadataColumns.metadataFieldIds()));
        ORC.ReadBuilder builder = ORC.read((InputFile)this.fileIO.newInputFile(((DataFile)task.file()).path().toString())).project(readSchemaWithoutConstantAndMetadataFields).split(task.start(), task.length()).createReaderFunc(this.getOrcReaderFunction(schema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
        }
        return builder.build();
    }

    protected abstract Function<MessageType, ParquetValueReader<?>> getParquetReaderFunction(Schema var1, Map<Integer, ?> var2);

    protected abstract Function<TypeDescription, OrcRowReader<?>> getOrcReaderFunction(Schema var1, Map<Integer, ?> var2);

    protected abstract Function<Schema, Function<T, StructLike>> toStructLikeFunction();

    private class GenericMixedDeleteFilter
    extends MixedDeleteFilter<T> {
        protected Function<T, StructLike> asStructLike;

        protected GenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec);
            this.asStructLike = AbstractKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        protected GenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes, StructLikeCollections structLikeCollections) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, sourceNodes, structLikeCollections);
            this.asStructLike = AbstractKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        protected GenericMixedDeleteFilter(KeyedTableScanTask keyedTableScanTask, Schema tableSchema, Schema requestedSchema, PrimaryKeySpec primaryKeySpec, Set<DataTreeNode> sourceNodes) {
            super(keyedTableScanTask, tableSchema, requestedSchema, primaryKeySpec, sourceNodes);
            this.asStructLike = AbstractKeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        @Override
        protected StructLike asStructLike(T record) {
            return this.asStructLike.apply(record);
        }

        @Override
        protected InputFile getInputFile(String location) {
            return AbstractKeyedDataReader.this.fileIO.newInputFile(location);
        }

        @Override
        protected AuthenticatedFileIO getFileIO() {
            return AbstractKeyedDataReader.this.fileIO;
        }
    }
}

