/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.WatermarkGenerator;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotUpdate;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MixedUpdate<T>
implements SnapshotUpdate<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MixedUpdate.class);
    protected final SnapshotUpdate<T> delegate;
    private final MixedTable mixedTable;
    protected final Transaction transaction;
    protected final boolean autoCommitTransaction;
    protected final WatermarkGenerator watermarkGenerator;

    public MixedUpdate(MixedTable mixedTable, SnapshotUpdate<T> delegate) {
        this.mixedTable = mixedTable;
        this.transaction = null;
        this.autoCommitTransaction = false;
        this.watermarkGenerator = null;
        this.delegate = delegate;
    }

    public MixedUpdate(MixedTable mixedTable, SnapshotUpdate<T> delegate, Transaction transaction, boolean autoCommitTransaction) {
        this.mixedTable = mixedTable;
        this.transaction = transaction;
        this.autoCommitTransaction = autoCommitTransaction;
        WatermarkGenerator watermarkGenerator = null;
        try {
            watermarkGenerator = WatermarkGenerator.forTable(mixedTable);
        }
        catch (Exception e) {
            LOG.warn("Failed to initialize watermark generator", (Throwable)e);
        }
        this.watermarkGenerator = watermarkGenerator;
        this.delegate = delegate;
    }

    protected void addIcebergDataFile(DataFile file) {
        if (this.watermarkGenerator != null) {
            this.watermarkGenerator.addFile(file);
        }
    }

    protected void deleteIcebergDataFile(DataFile file) {
        if (this.watermarkGenerator != null) {
            this.watermarkGenerator.addFile(file);
        }
    }

    protected void addIcebergDeleteFile(DeleteFile file) {
        if (this.watermarkGenerator != null) {
            this.watermarkGenerator.addFile(file);
        }
    }

    protected void deleteIcebergDeleteFile(DeleteFile file) {
        if (this.watermarkGenerator != null) {
            this.watermarkGenerator.addFile(file);
        }
    }

    public T set(String property, String value) {
        this.delegate.set(property, value);
        return this.self();
    }

    public T deleteWith(Consumer<String> deleteFunc) {
        this.delegate.deleteWith(deleteFunc);
        return this.self();
    }

    public T stageOnly() {
        this.delegate.stageOnly();
        return this.self();
    }

    public T scanManifestsWith(ExecutorService executorService) {
        this.delegate.scanManifestsWith(executorService);
        return this.self();
    }

    public Snapshot apply() {
        return (Snapshot)this.delegate.apply();
    }

    public Object updateEvent() {
        return this.delegate.updateEvent();
    }

    protected abstract T self();

    public void commit() {
        this.delegate.commit();
        if (this.transaction != null && this.watermarkGenerator != null) {
            long currentWatermark = TablePropertyUtil.getTableWatermark(this.mixedTable.properties());
            long newWatermark = this.watermarkGenerator.watermark();
            if (newWatermark > currentWatermark) {
                this.transaction.updateProperties().set("watermark.table", String.valueOf(newWatermark)).commit();
            }
        }
        if (this.transaction != null && this.autoCommitTransaction) {
            this.transaction.commitTransaction();
        }
    }

    public T toBranch(String branch) {
        this.delegate.toBranch(branch);
        return this.self();
    }

    public static abstract class Builder<T extends I, I> {
        protected final MixedTable table;
        protected Table tableStore;
        protected boolean onChangeStore = false;
        protected Transaction insideTransaction;
        protected boolean generateWatermark = false;

        protected Builder(MixedTable table) {
            this.table = table;
        }

        public Builder<T, I> onChange() {
            this.onChangeStore = true;
            return this;
        }

        public Builder<T, I> onTableStore(Table tableStore) {
            this.tableStore = tableStore;
            return this;
        }

        public Builder<T, I> inTransaction(Transaction transaction) {
            this.insideTransaction = transaction;
            return this;
        }

        public Builder<T, I> generateWatermark() {
            this.generateWatermark = true;
            return this;
        }

        protected Table getTableStore() {
            if (this.tableStore == null) {
                this.tableStore = this.table.isKeyedTable() ? (this.onChangeStore ? this.table.asKeyedTable().changeTable() : this.table.asKeyedTable().baseTable()) : this.table.asUnkeyedTable();
            }
            return this.tableStore;
        }

        public T build() {
            Table tableStore = this.getTableStore();
            if (this.generateWatermark) {
                if (this.insideTransaction != null) {
                    return this.updateWithWatermark(this.insideTransaction, false);
                }
                Transaction transaction = tableStore.newTransaction();
                return this.updateWithWatermark(transaction, true);
            }
            if (this.insideTransaction != null) {
                return this.updateWithoutWatermark(this.transactionDelegateSupplier(this.insideTransaction));
            }
            return this.updateWithoutWatermark(this.tableStoreDelegateSupplier(tableStore));
        }

        protected abstract T updateWithWatermark(Transaction var1, boolean var2);

        protected abstract T updateWithoutWatermark(Supplier<I> var1);

        protected abstract Supplier<I> transactionDelegateSupplier(Transaction var1);

        protected abstract Supplier<I> tableStoreDelegateSupplier(Table var1);
    }
}

