/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.io.Serializable;
import java.util.Objects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class TableIdentifier
implements Serializable {
    private String catalog;
    private String database;
    private String tableName;

    public TableIdentifier() {
    }

    private TableIdentifier(String catalog, String database, String tableName) {
        this.catalog = (String)Preconditions.checkNotNull((Object)catalog, (Object)"Catalog name must not be null.");
        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"Database name must not be null.");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"Table name must not be null.");
    }

    public static TableIdentifier of(String catalog, String database, String tableName) {
        return new TableIdentifier(catalog, database, tableName);
    }

    public static TableIdentifier of(org.apache.amoro.api.TableIdentifier identifier) {
        return new TableIdentifier(identifier.getCatalog(), identifier.getDatabase(), identifier.getTableName());
    }

    public TableIdentifier(org.apache.amoro.api.TableIdentifier tableIdentifier) {
        this(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName());
    }

    public org.apache.amoro.api.TableIdentifier buildTableIdentifier() {
        return new org.apache.amoro.api.TableIdentifier(this.catalog, this.database, this.tableName);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableIdentifier that = (TableIdentifier)o;
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.database, that.database)) {
            return false;
        }
        return Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        int result = this.catalog != null ? this.catalog.hashCode() : 0;
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.catalog, this.database, this.tableName);
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableIdentifier toLowCaseIdentifier() {
        return new TableIdentifier(this.catalog, this.database.toLowerCase(), this.tableName.toLowerCase());
    }
}

