/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.Set;
import java.util.function.Function;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.PrimaryKeyData;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.Filter;

public class NodeFilter<T>
extends Filter<T> {
    private final Set<DataTreeNode> sourceNodes;
    private final PrimaryKeyData primaryKey;
    private final Function<T, StructLike> asStructLike;

    public NodeFilter(Set<DataTreeNode> sourceNodes, Schema schema, PrimaryKeySpec primaryKeySpec, Function<T, StructLike> asStructLike) {
        this.sourceNodes = sourceNodes;
        this.primaryKey = new PrimaryKeyData(primaryKeySpec, schema);
        this.asStructLike = asStructLike;
    }

    protected boolean shouldKeep(T record) {
        if (this.sourceNodes == null) {
            return true;
        }
        if (this.sourceNodes.isEmpty()) {
            return false;
        }
        this.primaryKey.primaryKey(this.asStructLike.apply(record));
        return this.sourceNodes.stream().anyMatch(node -> ((long)this.primaryKey.hashCode() & node.mask()) == node.index());
    }
}

