/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class SerializationUtil {
    private static final ThreadLocal<KryoSerializerInstance> KRYO_SERIALIZER = ThreadLocal.withInitial(KryoSerializerInstance::new);

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer simpleSerialize(Object obj) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(obj);
                oos.flush();
                byteBuffer = ByteBuffer.wrap(bos.toByteArray());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("serialization error of " + obj, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T simpleDeserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                object = ois.readObject();
            }
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("deserialization error ", e);
        }
    }

    public static byte[] kryoSerialize(Object obj) {
        return KRYO_SERIALIZER.get().serialize(obj);
    }

    public static <T> T kryoDeserialize(byte[] objectData) {
        if (objectData == null) {
            throw new NullPointerException("The byte[] must not be null");
        }
        return (T)KRYO_SERIALIZER.get().deserialize(objectData);
    }

    public static <T> SimpleSerializer<T> createJavaSimpleSerializer() {
        return JavaSerializer.INSTANT;
    }

    public static SimpleSerializer<StructLikeWrapper> createStructLikeWrapperSerializer(StructLikeWrapper structLikeWrapper) {
        return new StructLikeWrapperSerializer(structLikeWrapper);
    }

    private static class KryoSerializerInstance
    implements Serializable {
        public static final int KRYO_SERIALIZER_INITIAL_BUFFER_SIZE = 0x100000;
        private final Kryo kryo;
        private final ByteArrayOutputStream outputStream;

        KryoSerializerInstance() {
            KryoInstantiator kryoInstantiator = new KryoInstantiator();
            this.kryo = kryoInstantiator.newKryo();
            this.outputStream = new ByteArrayOutputStream(0x100000);
            this.kryo.setRegistrationRequired(false);
        }

        byte[] serialize(Object obj) {
            this.kryo.reset();
            this.outputStream.reset();
            Output output = new Output((OutputStream)this.outputStream);
            this.kryo.writeClassAndObject(output, obj);
            output.close();
            return this.outputStream.toByteArray();
        }

        Object deserialize(byte[] objectData) {
            return this.kryo.readClassAndObject(new Input(objectData));
        }
    }

    public static class JavaSerializer<T extends Serializable>
    implements SimpleSerializer<T> {
        public static final JavaSerializer INSTANT = new JavaSerializer();

        @Override
        public byte[] serialize(T t) {
            Preconditions.checkNotNull(t);
            return SerializationUtil.kryoSerialize(t);
        }

        @Override
        public T deserialize(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            return (T)((Serializable)SerializationUtil.kryoDeserialize(bytes));
        }
    }

    public static class StructLikeWrapperSerializer
    implements SimpleSerializer<StructLikeWrapper> {
        protected final StructLikeWrapper structLikeWrapper;

        public StructLikeWrapperSerializer(StructLikeWrapper structLikeWrapper) {
            this.structLikeWrapper = structLikeWrapper;
        }

        public StructLikeWrapperSerializer(Types.StructType type) {
            this.structLikeWrapper = StructLikeWrapper.forType((Types.StructType)type);
        }

        @Override
        public byte[] serialize(StructLikeWrapper structLikeWrapper) {
            Preconditions.checkNotNull((Object)structLikeWrapper);
            StructLike copy = StructLikeCopy.copy(structLikeWrapper.get());
            return SerializationUtil.kryoSerialize(copy);
        }

        @Override
        public StructLikeWrapper deserialize(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            StructLikeCopy structLike = (StructLikeCopy)SerializationUtil.kryoDeserialize(bytes);
            return this.structLikeWrapper.copyFor((StructLike)structLike);
        }
    }

    public static class StructLikeCopy
    implements StructLike {
        private final Object[] values;

        public static StructLike copy(StructLike struct) {
            return struct != null ? new StructLikeCopy(struct) : null;
        }

        private StructLikeCopy(StructLike toCopy) {
            this.values = new Object[toCopy.size()];
            for (int i = 0; i < this.values.length; ++i) {
                Object value = toCopy.get(i, Object.class);
                this.values[i] = value instanceof StructLike ? StructLikeCopy.copy((StructLike)value) : value;
            }
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Struct copy cannot be modified");
        }
    }

    public static interface SimpleSerializer<T> {
        public byte[] serialize(T var1);

        public T deserialize(byte[] var1);
    }

    private static class AvroUtf8Serializer
    extends Serializer<Utf8> {
        private AvroUtf8Serializer() {
        }

        public void write(Kryo kryo, Output output, Utf8 utf8String) {
            Serializer bytesSerializer = kryo.getDefaultSerializer(byte[].class);
            bytesSerializer.write(kryo, output, (Object)utf8String.getBytes());
        }

        public Utf8 read(Kryo kryo, Input input, Class<Utf8> type) {
            Serializer bytesSerializer = kryo.getDefaultSerializer(byte[].class);
            byte[] bytes = (byte[])bytesSerializer.read(kryo, input, byte[].class);
            return new Utf8(bytes);
        }
    }

    private static class KryoInstantiator
    implements Serializable {
        private KryoInstantiator() {
        }

        public Kryo newKryo() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            kryo.register(Utf8.class, (Serializer)new AvroUtf8Serializer());
            return kryo;
        }
    }
}

