/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.MixedDataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;

public class TablePropertyUtil {
    public static final StructLike EMPTY_STRUCT = GenericRecord.create((Schema)new Schema(new Types.NestedField[0]));

    public static StructLikeMap<Map<String, String>> decodePartitionProperties(PartitionSpec spec, String value) {
        try {
            StructLikeMap results = StructLikeMap.create((Types.StructType)spec.partitionType());
            TypeReference<Map<String, Map<String, String>>> typeReference = new TypeReference<Map<String, Map<String, String>>>(){};
            Map map = (Map)new ObjectMapper().readValue(value, (TypeReference)typeReference);
            for (String key : map.keySet()) {
                if (spec.isUnpartitioned()) {
                    results.put(EMPTY_STRUCT, (Object)((Map)map.get(key)));
                    continue;
                }
                GenericRecord partitionData = MixedDataFiles.data(spec, key);
                results.put((StructLike)partitionData, (Object)((Map)map.get(key)));
            }
            return results;
        }
        catch (JsonProcessingException e) {
            throw new UnsupportedOperationException("Failed to decode partition max txId ", e);
        }
    }

    public static String encodePartitionProperties(PartitionSpec spec, StructLikeMap<Map<String, String>> partitionProperties) {
        String value;
        HashMap stringKeyMap = Maps.newHashMap();
        for (StructLike pd : partitionProperties.keySet()) {
            String pathLike = spec.partitionToPath(pd);
            stringKeyMap.put(pathLike, (Map)partitionProperties.get((Object)pd));
        }
        try {
            value = new ObjectMapper().writeValueAsString((Object)stringKeyMap);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
        return value;
    }

    public static StructLikeMap<Long> getPartitionLongProperties(UnkeyedTable unkeyedTable, String key) {
        StructLikeMap result = StructLikeMap.create((Types.StructType)unkeyedTable.spec().partitionType());
        StructLikeMap<Map<String, String>> partitionProperty = unkeyedTable.partitionProperty();
        partitionProperty.forEach((partitionKey, propertyValue) -> {
            Long longValue;
            Long l = longValue = propertyValue == null || propertyValue.get(key) == null ? null : Long.valueOf(Long.parseLong((String)propertyValue.get(key)));
            if (longValue != null) {
                result.put(partitionKey, longValue);
            }
        });
        return result;
    }

    public static Map<String, String> getPartitionProperties(MixedTable mixedTable, StructLike partition) {
        return TablePropertyUtil.getPartitionProperties(mixedTable.isKeyedTable() ? mixedTable.asKeyedTable().baseTable() : mixedTable.asUnkeyedTable(), partition);
    }

    public static Map<String, String> getPartitionProperties(UnkeyedTable unkeyedTable, StructLike partitionData) {
        Map result = Maps.newHashMap();
        StructLikeMap<Map<String, String>> partitionProperty = unkeyedTable.partitionProperty();
        if (partitionProperty.containsKey((Object)partitionData)) {
            result = (Map)partitionProperty.get((Object)partitionData);
        }
        return result;
    }

    public static long getTableWatermark(Map<String, String> properties) {
        String watermarkValue = properties.get("watermark.table");
        if (watermarkValue == null) {
            return -1L;
        }
        return Long.parseLong(watermarkValue);
    }

    public static boolean isMixedTableStore(Map<String, String> properties) {
        String format = properties.get("table-format");
        String tableStore = properties.get("mixed-format.table-store");
        boolean baseStore = "base".equalsIgnoreCase(tableStore);
        boolean changeStore = "change".equalsIgnoreCase(tableStore);
        return TableFormat.MIXED_ICEBERG.name().equalsIgnoreCase(format) && (baseStore || changeStore);
    }

    public static boolean isBaseStore(Map<String, String> properties, TableFormat format) {
        String tableFormat = properties.get("table-format");
        String tableStore = properties.get("mixed-format.table-store");
        return format.name().equalsIgnoreCase(tableFormat) && "base".equalsIgnoreCase(tableStore);
    }

    public static TableIdentifier parseChangeIdentifier(Map<String, String> properties) {
        Preconditions.checkArgument((boolean)properties.containsKey("mixed-format.change.identifier"), (Object)"can read change store identifier from base store properties");
        String change = properties.get("mixed-format.change.identifier");
        return TableIdentifier.parse((String)change);
    }

    public static PrimaryKeySpec parsePrimaryKeySpec(Schema schema, Map<String, String> tableProperties) {
        if (tableProperties.containsKey("mixed-format.primary-key-fields")) {
            return PrimaryKeySpec.fromDescription(schema, tableProperties.get("mixed-format.primary-key-fields"));
        }
        return PrimaryKeySpec.noPrimaryKey();
    }

    public static Map<String, String> commonMixedProperties(PrimaryKeySpec keySpec, TableFormat format) {
        HashMap properties = Maps.newHashMap();
        properties.put("table-format", format.name());
        if (keySpec.primaryKeyExisted()) {
            properties.put("mixed-format.primary-key-fields", keySpec.description());
        }
        properties.put("table.create-timestamp", String.valueOf(System.currentTimeMillis()));
        properties.put("format-version", "2");
        properties.put("write.metadata.delete-after-commit.enabled", "true");
        properties.put("flink.max-continuous-empty-commits", String.valueOf(Integer.MAX_VALUE));
        return properties;
    }

    public static Map<String, String> baseStoreProperties(PrimaryKeySpec keySpec, TableIdentifier changeIdentifier, TableFormat format) {
        Map<String, String> properties = TablePropertyUtil.commonMixedProperties(keySpec, format);
        properties.put("mixed-format.table-store", "base");
        if (keySpec.primaryKeyExisted()) {
            properties.put("mixed-format.change.identifier", changeIdentifier.toString());
        }
        return properties;
    }

    public static Map<String, String> changeStoreProperties(PrimaryKeySpec keySpec, TableFormat format) {
        Map<String, String> properties = TablePropertyUtil.commonMixedProperties(keySpec, format);
        properties.put("mixed-format.table-store", "change");
        return properties;
    }
}

