/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;

public class IcebergSchemaUtil {
    public static PartitionSpec copyPartitionSpec(PartitionSpec partitionSpec, Schema copySchema) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)copySchema);
        partitionSpec.fields().forEach(partitionField -> builder.add(partitionField.sourceId(), partitionField.name().toLowerCase(), partitionField.transform()));
        return builder.build();
    }

    public static SortOrder copySortOrderSpec(SortOrder sortOrder, Schema copySchema) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)copySchema);
        sortOrder.fields().forEach(sortField -> builder.addSortField(sortField.transform(), sortField.sourceId(), sortField.direction(), sortField.nullOrder()));
        return builder.build();
    }

    public static PartitionSpec projectPartition(PartitionSpec partitionSpec, Schema schema) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        partitionSpec.fields().forEach(p -> {
            if (schema.findField(p.sourceId()) == null) {
                return;
            }
            builder.add(p.sourceId(), p.name(), p.transform());
        });
        return builder.build();
    }
}

