/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StringType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tMuAB\u001e=\u0011\u0003s$J\u0002\u0004My!\u0005e(\u0014\u0005\u0006;\u0006!\ta\u0018\u0005\bA\u0006\u0011\r\u0011\"\u0011b\u0011\u0019)\u0017\u0001)A\u0005E\"9a-\u0001b\u0001\n\u00039\u0007BB6\u0002A\u0003%\u0001\u000eC\u0003m\u0003\u0011\u0005S\u000eC\u0004\u00022\u0006!\t%a-\t\u000f\t\u0005\u0013\u0001\"\u0011\u0003D\u00191\u0011\u0011X\u0001\u0001\u0003wC!\"a\u0007\u000b\u0005\u0003\u0005\u000b\u0011BAd\u0011\u0019i&\u0002\"\u0001\u0002J\"A\u0011q\u001a\u0006A\u0002\u0013%\u0011\rC\u0005\u0002R*\u0001\r\u0011\"\u0003\u0002T\"9\u0011q\u001b\u0006!B\u0013\u0011\u0007\"CAm\u0015\u0001\u0007I\u0011BAD\u0011%\tYN\u0003a\u0001\n\u0013\ti\u000e\u0003\u0005\u0002b*\u0001\u000b\u0015BAE\u0011!\t\u0019O\u0003a\u0001\n\u0013\t\u0007\"CAs\u0015\u0001\u0007I\u0011BAt\u0011\u001d\tYO\u0003Q!\n\tD\u0011\"!<\u000b\u0001\u0004%I!a<\t\u0013\t\u001d!\u00021A\u0005\n\t%\u0001\u0002\u0003B\u0007\u0015\u0001\u0006K!!=\t\u0013\u0005E\"B1A\u0005\n\t=\u0001\u0002CA!\u0015\u0001\u0006IA!\u0005\t\u0011\t]!\u00021A\u0005\n\u0005D\u0011B!\u0007\u000b\u0001\u0004%IAa\u0007\t\u000f\t}!\u0002)Q\u0005E\"9!\u0011\u0005\u0006\u0005B\t\r\u0002b\u0002B\u0015\u0015\u0011\u0005#1\u0006\u0005\u0007\u0005kQA\u0011I1\t\r\t]\"\u0002\"\u0011b\r\u0011\t\u0018\u0001\u0001:\t\u0015\u0005%!E!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u001c\t\u0012\t\u0011)A\u0005\u0003;Aa!\u0018\u0012\u0005\u0002\u0005\u0015\u0002\u0002CA\u0017E\t\u0007I\u0011A1\t\u000f\u0005=\"\u0005)A\u0005E\"I\u0011\u0011\u0007\u0012C\u0002\u0013%\u00111\u0007\u0005\t\u0003\u0003\u0012\u0003\u0015!\u0003\u00026!I\u00111\t\u0012A\u0002\u0013%\u0011Q\t\u0005\n\u0003\u0013\u0012\u0003\u0019!C\u0005\u0003\u0017B\u0001\"a\u0016#A\u0003&\u0011q\t\u0005\n\u00033\u0012\u0003\u0019!C\u0005\u00037B\u0011\"!\u001a#\u0001\u0004%I!a\u001a\t\u0011\u0005-$\u0005)Q\u0005\u0003;Bq!!\u001c#\t\u0003\ny\u0007C\u0004\u0002\u0006\n\"\t%a\"\t\u000f\u0005=%\u0005\"\u0011\u0002\u0012\"I!qK\u0001\u0002\u0002\u0013\u0005#\u0011\f\u0005\t\u0005O\n\u0011\u0011!C\u0001C\"I!\u0011N\u0001\u0002\u0002\u0013\u0005!1\u000e\u0005\n\u0005_\n\u0011\u0011!C!\u0005cB\u0011Ba\u001f\u0002\u0003\u0003%\tA! \t\u0013\t\u0005\u0015!!A\u0005B\t\r\u0005\"\u0003BC\u0003\u0005\u0005I\u0011\tBD\u0011%\u0011I)AA\u0001\n\u0013\u0011Y)\u0001\nES\u000e$\u0018n\u001c8bef,enY8eS:<'BA\u001f?\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005}\u0002\u0015\u0001C2pYVlg.\u0019:\u000b\u0005\u0005\u0013\u0015!C3yK\u000e,H/[8o\u0015\t\u0019E)A\u0002tc2T!!\u0012$\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'o\u001a\t\u0003\u0017\u0006i\u0011\u0001\u0010\u0002\u0013\t&\u001cG/[8oCJLXI\\2pI&twmE\u0003\u0002\u001dR;&\f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017VK!A\u0016\u001f\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002P1&\u0011\u0011\f\u0015\u0002\b!J|G-^2u!\ty5,\u0003\u0002]!\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001K\u0003\u0019!\u0018\u0010]3JIV\t!\r\u0005\u0002PG&\u0011A\r\u0015\u0002\u0004\u0013:$\u0018a\u0002;za\u0016LE\rI\u0001\u000e\u001b\u0006Cv\fR%D)~\u001b\u0016JW#\u0016\u0003!\u0004\"aT5\n\u0005)\u0004&!B*i_J$\u0018AD'B1~#\u0015j\u0011+`'&SV\tI\u0001\bI\u0016\u001cw\u000eZ3s+\rq\u0017\u0011\u0016\u000b\u0006_\u0006-\u0016Q\u0016\t\u0005a\n\n9+D\u0001\u0002\u0005\u001d!UmY8eKJ,\"a\u001d=\u0014\u0007\trE\u000fE\u0002LkZL!!\u001d\u001f\u0011\u0005]DH\u0002\u0001\u0003\u0006s\n\u0012\rA\u001f\u0002\u0002)F\u00111P \t\u0003\u001frL!! )\u0003\u000f9{G\u000f[5oOB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0005\u0006)A/\u001f9fg&!\u0011qAA\u0001\u0005)\tEo\\7jGRK\b/Z\u0001\u0007EV4g-\u001a:\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005\u0019a.[8\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\u0010\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\r|G.^7o)f\u0004X\rE\u0003\u0002 \u0005\u0005b/D\u0001?\u0013\r\t\u0019C\u0010\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016$b!a\n\u0002*\u0005-\u0002c\u00019#m\"9\u0011\u0011B\u0013A\u0002\u0005-\u0001bBA\u000eK\u0001\u0007\u0011QD\u0001\u000bK2,W.\u001a8u\u001dVl\u0017aC3mK6,g\u000e\u001e(v[\u0002\n!\u0002Z5di&|g.\u0019:z+\t\t)\u0004E\u0003P\u0003o\tY$C\u0002\u0002:A\u0013Q!\u0011:sCf\u00042aTA\u001f\u0013\r\ty\u0004\u0015\u0002\u0004\u0003:L\u0018a\u00033jGRLwN\\1ss\u0002\nQ\"\u001b8u\t&\u001cG/[8oCJLXCAA$!\u0011y\u0015q\u00072\u0002#%tG\u000fR5di&|g.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005M\u0003cA(\u0002P%\u0019\u0011\u0011\u000b)\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+Z\u0013\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u00039Ig\u000e\u001e#jGRLwN\\1ss\u0002\na\u0002\\8oO\u0012K7\r^5p]\u0006\u0014\u00180\u0006\u0002\u0002^A)q*a\u000e\u0002`A\u0019q*!\u0019\n\u0007\u0005\r\u0004K\u0001\u0003M_:<\u0017A\u00057p]\u001e$\u0015n\u0019;j_:\f'/_0%KF$B!!\u0014\u0002j!I\u0011Q\u000b\u0018\u0002\u0002\u0003\u0007\u0011QL\u0001\u0010Y>tw\rR5di&|g.\u0019:zA\u0005!a.\u001a=u)\u0019\ti%!\u001d\u0002\u0002\"9\u00111\u000f\u0019A\u0002\u0005U\u0014a\u0001:poB!\u0011qOA?\u001b\t\tIHC\u0002\u0002|\t\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0003\u007f\nIHA\u0006J]R,'O\\1m%><\bBBABa\u0001\u0007!-A\u0004pe\u0012Lg.\u00197\u0002\u000f!\f7OT3yiV\u0011\u0011\u0011\u0012\t\u0004\u001f\u0006-\u0015bAAG!\n9!i\\8mK\u0006t\u0017A\u00033fG>l\u0007O]3tgR1\u0011QJAJ\u0003GCq!!&3\u0001\u0004\t9*\u0001\u0007d_2,XN\u001c,fGR|'\u000f\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\ti\nQ\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BAQ\u00037\u0013Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\bBBASe\u0001\u0007!-\u0001\u0005dCB\f7-\u001b;z!\r9\u0018\u0011\u0016\u0003\u0006s\u001e\u0011\rA\u001f\u0005\b\u0003\u00139\u0001\u0019AA\u0006\u0011\u001d\tYb\u0002a\u0001\u0003_\u0003b!a\b\u0002\"\u0005\u001d\u0016aB3oG>$WM]\u000b\u0005\u0003k\u0013Y\u0004\u0006\u0003\u00028\nu\u0002\u0003\u00029\u000b\u0005s\u0011q!\u00128d_\u0012,'/\u0006\u0003\u0002>\u0006\u00157\u0003\u0002\u0006O\u0003\u007f\u0003RaSAa\u0003\u0007L1!!/=!\r9\u0018Q\u0019\u0003\u0006s*\u0011\rA\u001f\t\u0007\u0003?\t\t#a1\u0015\t\u0005-\u0017Q\u001a\t\u0005a*\t\u0019\rC\u0004\u0002\u001c1\u0001\r!a2\u0002#}+hnY8naJ,7o]3e'&TX-A\u000b`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016|F%Z9\u0015\t\u00055\u0013Q\u001b\u0005\t\u0003+r\u0011\u0011!a\u0001E\u0006\u0011r,\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3!\u0003!yg/\u001a:gY><\u0018\u0001D8wKJ4Gn\\<`I\u0015\fH\u0003BA'\u0003?D\u0011\"!\u0016\u0012\u0003\u0003\u0005\r!!#\u0002\u0013=4XM\u001d4m_^\u0004\u0013!B2pk:$\u0018!C2pk:$x\fJ3r)\u0011\ti%!;\t\u0011\u0005UC#!AA\u0002\t\faaY8v]R\u0004\u0013A\u0002<bYV,7/\u0006\u0002\u0002rB1\u00111_A\u007f\u0005\u0003i!!!>\u000b\t\u0005]\u0018\u0011`\u0001\b[V$\u0018M\u00197f\u0015\r\tY\u0010U\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0000\u0003k\u00141\"\u0011:sCf\u0014UO\u001a4feB!\u00111\u0019B\u0002\u0013\u0011\u0011)!!\u0002\u0003\u0019%sG/\u001a:oC2$\u0016\u0010]3\u0002\u0015Y\fG.^3t?\u0012*\u0017\u000f\u0006\u0003\u0002N\t-\u0001\"CA+/\u0005\u0005\t\u0019AAy\u0003\u001d1\u0018\r\\;fg\u0002*\"A!\u0005\u0011\u000f\u0005M(1CA\u001eQ&!!QCA{\u0005\u001dA\u0015m\u001d5NCB\fa\u0002Z5di&|g.\u0019:z'&TX-\u0001\neS\u000e$\u0018n\u001c8bef\u001c\u0016N_3`I\u0015\fH\u0003BA'\u0005;A\u0001\"!\u0016\u001d\u0003\u0003\u0005\rAY\u0001\u0010I&\u001cG/[8oCJL8+\u001b>fA\u0005Qr-\u0019;iKJ\u001cu.\u001c9sKN\u001c\u0018NY5mSRL8\u000b^1ugR1\u0011Q\nB\u0013\u0005OAq!a\u001d\u001f\u0001\u0004\t)\b\u0003\u0004\u0002\u0004z\u0001\rAY\u0001\tG>l\u0007O]3tgR1\u00111\u0002B\u0017\u0005cAqAa\f \u0001\u0004\tY!\u0001\u0003ge>l\u0007b\u0002B\u001a?\u0001\u0007\u00111B\u0001\u0003i>\f\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u001d\r|W\u000e\u001d:fgN,GmU5{KB\u0019qOa\u000f\u0005\u000beD!\u0019\u0001>\t\u000f\u0005m\u0001\u00021\u0001\u0003@A1\u0011qDA\u0011\u0005s\t\u0001b];qa>\u0014Ho\u001d\u000b\u0005\u0003\u0013\u0013)\u0005C\u0004\u0002\u001c%\u0001\rAa\u00121\t\t%#\u0011\u000b\t\u0007\u0003?\u0011YEa\u0014\n\u0007\t5cH\u0001\u0006D_2,XN\u001c+za\u0016\u00042a\u001eB)\t1\u0011\u0019F!\u0012\u0002\u0002\u0003\u0005)\u0011\u0001B+\u0005\ryFeM\t\u0004w\u0006m\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\\A!!Q\fB2\u001b\t\u0011yF\u0003\u0003\u0003b\u0005M\u0011\u0001\u00027b]\u001eLAA!\u001a\u0003`\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002<\t5\u0004\u0002CA+k\u0005\u0005\t\u0019\u00012\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001d\u0011\r\tU$qOA\u001e\u001b\t\tI0\u0003\u0003\u0003z\u0005e(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!#\u0003\u0000!I\u0011QK\u001c\u0002\u0002\u0003\u0007\u00111H\u0001\tQ\u0006\u001c\bnQ8eKR\t!-\u0001\u0005u_N#(/\u001b8h)\t\u0011Y&A\u0006sK\u0006$'+Z:pYZ,GC\u0001BG!\u0011\u0011iFa$\n\t\tE%q\f\u0002\u0007\u001f\nTWm\u0019;")
public final class DictionaryEncoding {
    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return DictionaryEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return DictionaryEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static <T extends AtomicType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return DictionaryEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof IntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException("Not supported type in DictionaryEncoding.");
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof IntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof LongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (t instanceof StringType) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends AtomicType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private void values_$eq(ArrayBuffer<Object> x$1) {
            this.values = x$1;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            block3: {
                Object value = this.columnType.getField(row, ordinal);
                if (this.overflow()) break block3;
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                    } else {
                        this.overflow_$eq(true);
                        this.values().clear();
                        this.dictionary().clear();
                    }
                }
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw QueryExecutionErrors$.MODULE$.useDictionaryEncodingWhenDictionaryOverflowError();
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this.overflow() ? Integer.MAX_VALUE : this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

