/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.amoro.hive.utils.CatalogUtil;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.mixed.MixedSparkCatalogBase;
import org.apache.amoro.spark.mixed.MixedTableStoreType;
import org.apache.amoro.spark.table.MixedSparkTable;
import org.apache.amoro.spark.table.SparkChangeTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public class MixedFormatSparkCatalog
extends MixedSparkCatalogBase {
    public Table loadTable(Identifier ident) throws NoSuchTableException {
        MixedTable table;
        this.checkAndRefreshCatalogMeta();
        try {
            if (this.isInnerTableIdentifier(ident)) {
                MixedTableStoreType type = MixedTableStoreType.from((String)ident.name());
                TableIdentifier identifier = this.buildInnerTableIdentifier(ident);
                MixedTable table2 = this.catalog.loadTable(identifier);
                return this.loadInnerTable(table2, type);
            }
            TableIdentifier identifier = this.buildIdentifier(ident);
            table = this.catalog.loadTable(identifier);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
        return MixedSparkTable.ofMixedTable(table, this.catalog, this.name());
    }

    private Table loadInnerTable(MixedTable table, MixedTableStoreType type) {
        if (type != null) {
            switch (type) {
                case CHANGE: {
                    return new SparkChangeTable((BasicUnkeyedTable)table.asKeyedTable().changeTable(), false);
                }
            }
            throw new IllegalArgumentException("Unknown inner table type: " + type);
        }
        throw new IllegalArgumentException("Table does not exist: " + table);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException {
        this.checkAndRefreshCatalogMeta();
        properties = Maps.newHashMap(properties);
        Schema finalSchema = this.checkAndConvertSchema(schema, properties);
        TableIdentifier identifier = this.buildIdentifier(ident);
        TableBuilder builder = this.catalog.newTableBuilder(identifier, finalSchema);
        PartitionSpec spec = Spark3Util.toPartitionSpec((Schema)finalSchema, (Transform[])transforms);
        if (properties.containsKey("location") && this.isIdentifierLocation((String)properties.get("location"), ident)) {
            properties.remove("location");
        }
        try {
            if (properties.containsKey("primary.keys")) {
                PrimaryKeySpec primaryKeySpec = PrimaryKeySpec.fromDescription((Schema)finalSchema, (String)((String)properties.get("primary.keys")));
                properties.remove("primary.keys");
                builder.withPartitionSpec(spec).withProperties((Map)properties).withPrimaryKeySpec(primaryKeySpec);
            } else {
                builder.withPartitionSpec(spec).withProperties((Map)properties);
            }
            MixedTable table = builder.create();
            return MixedSparkTable.ofMixedTable(table, this.catalog, this.name());
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException("Table " + ident + " already exists", Option.apply((Object)((Object)e)));
        }
    }

    private Schema checkAndConvertSchema(StructType schema, Map<String, String> properties) {
        Schema convertSchema;
        SparkSession sparkSession = SparkSession.active();
        boolean useTimestampWithoutZoneInNewTables = CatalogUtil.isMixedHiveCatalog((MixedFormatCatalog)this.catalog) ? true : Boolean.parseBoolean(sparkSession.conf().get("spark.sql.mixed-format.use-timestamp-without-timezone-in-new-tables", "false"));
        if (useTimestampWithoutZoneInNewTables) {
            sparkSession.conf().set("spark.sql.iceberg.handle-timestamp-without-timezone", true);
            convertSchema = SparkSchemaUtil.convert((StructType)schema, (boolean)true);
        } else {
            convertSchema = SparkSchemaUtil.convert((StructType)schema, (boolean)false);
        }
        if (properties.containsKey("primary.keys")) {
            PrimaryKeySpec primaryKeySpec = PrimaryKeySpec.fromDescription((Schema)convertSchema, (String)properties.get("primary.keys"));
            List primaryKeys = primaryKeySpec.fieldNames();
            HashSet pkSet = new HashSet(primaryKeys);
            HashSet identifierFieldIds = new HashSet();
            ArrayList columnsWithPk = new ArrayList();
            convertSchema.columns().forEach(nestedField -> {
                if (pkSet.contains(nestedField.name())) {
                    columnsWithPk.add(nestedField.asRequired());
                    identifierFieldIds.add(nestedField.fieldId());
                } else {
                    columnsWithPk.add(nestedField);
                }
            });
            return new Schema(columnsWithPk, identifierFieldIds);
        }
        return convertSchema;
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        MixedTable table;
        TableIdentifier identifier = this.buildIdentifier(ident);
        try {
            table = this.catalog.loadTable(identifier);
        }
        catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
            throw new NoSuchTableException(ident);
        }
        if (table.isUnkeyedTable()) {
            this.alterUnKeyedTable(table.asUnkeyedTable(), changes);
            return MixedSparkTable.ofMixedTable(table, this.catalog, this.name());
        }
        if (table.isKeyedTable()) {
            this.alterKeyedTable(table.asKeyedTable(), changes);
            return MixedSparkTable.ofMixedTable(table, this.catalog, this.name());
        }
        throw new UnsupportedOperationException("Unsupported alter table");
    }

    private void alterKeyedTable(KeyedTable table, TableChange ... changes) {
        ArrayList<TableChange> schemaChanges = new ArrayList<TableChange>();
        ArrayList<TableChange> propertyChanges = new ArrayList<TableChange>();
        for (TableChange change : changes) {
            if (change instanceof TableChange.ColumnChange) {
                schemaChanges.add(change);
                continue;
            }
            if (change instanceof TableChange.SetProperty) {
                propertyChanges.add(change);
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                propertyChanges.add(change);
                continue;
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
        this.commitKeyedChanges(table, schemaChanges, propertyChanges);
    }

    private void commitKeyedChanges(KeyedTable table, List<TableChange> schemaChanges, List<TableChange> propertyChanges) {
        if (!schemaChanges.isEmpty()) {
            Spark3Util.applySchemaChanges((UpdateSchema)table.updateSchema(), schemaChanges).commit();
        }
        if (!propertyChanges.isEmpty()) {
            Spark3Util.applyPropertyChanges((UpdateProperties)table.updateProperties(), propertyChanges).commit();
        }
    }

    private void alterUnKeyedTable(UnkeyedTable table, TableChange ... changes) {
        TableChange.SetProperty setLocation = null;
        TableChange.SetProperty setSnapshotId = null;
        TableChange.SetProperty pickSnapshotId = null;
        ArrayList<TableChange> propertyChanges = new ArrayList<TableChange>();
        ArrayList<TableChange> schemaChanges = new ArrayList<TableChange>();
        for (TableChange change : changes) {
            if (change instanceof TableChange.SetProperty) {
                TableChange.SetProperty set = (TableChange.SetProperty)change;
                if ("location".equalsIgnoreCase(set.property())) {
                    setLocation = set;
                    continue;
                }
                if ("current-snapshot-id".equalsIgnoreCase(set.property())) {
                    setSnapshotId = set;
                    continue;
                }
                if ("cherry-pick-snapshot-id".equalsIgnoreCase(set.property())) {
                    pickSnapshotId = set;
                    continue;
                }
                if ("sort-order".equalsIgnoreCase(set.property())) {
                    throw new UnsupportedOperationException("Cannot specify the 'sort-order' because it's a reserved table property. Please use the command 'ALTER TABLE ... WRITE ORDERED BY' to specify write sort-orders.");
                }
                propertyChanges.add((TableChange)set);
                continue;
            }
            if (change instanceof TableChange.RemoveProperty) {
                propertyChanges.add(change);
                continue;
            }
            if (change instanceof TableChange.ColumnChange) {
                schemaChanges.add(change);
                continue;
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
        this.commitUnKeyedChanges(table, setLocation, setSnapshotId, pickSnapshotId, propertyChanges, schemaChanges);
    }

    protected void commitUnKeyedChanges(UnkeyedTable table, TableChange.SetProperty setLocation, TableChange.SetProperty setSnapshotId, TableChange.SetProperty pickSnapshotId, List<TableChange> propertyChanges, List<TableChange> schemaChanges) {
        long newSnapshotId;
        Preconditions.checkArgument((setSnapshotId == null || pickSnapshotId == null ? 1 : 0) != 0, (Object)"Cannot set the current the current snapshot ID and cherry-pick snapshot changes");
        if (setSnapshotId != null) {
            newSnapshotId = Long.parseLong(setSnapshotId.value());
            table.manageSnapshots().setCurrentSnapshot(newSnapshotId).commit();
        }
        if (pickSnapshotId != null) {
            newSnapshotId = Long.parseLong(pickSnapshotId.value());
            table.manageSnapshots().cherrypick(newSnapshotId).commit();
        }
        Transaction transaction = table.newTransaction();
        if (setLocation != null) {
            transaction.updateLocation().setLocation(setLocation.value()).commit();
        }
        if (!propertyChanges.isEmpty()) {
            Spark3Util.applyPropertyChanges((UpdateProperties)transaction.updateProperties(), propertyChanges).commit();
        }
        if (!schemaChanges.isEmpty()) {
            Spark3Util.applySchemaChanges((UpdateSchema)transaction.updateSchema(), schemaChanges).commit();
        }
        transaction.commitTransaction();
    }
}

