/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.table;

import java.util.HashMap;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.spark.util.MixedFormatSparkUtils;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.types.StructType;

public class UnkeyedSparkTable
extends SparkTable
implements SupportsPartitionManagement {
    private final UnkeyedTable unkeyedTable;
    private final String sparkCatalogName;

    public UnkeyedSparkTable(UnkeyedTable unkeyedTable, boolean refreshEagerly, String sparkCatalogName) {
        super((Table)unkeyedTable, refreshEagerly);
        this.unkeyedTable = unkeyedTable;
        this.sparkCatalogName = sparkCatalogName;
    }

    public UnkeyedTable table() {
        return this.unkeyedTable;
    }

    public String name() {
        return this.sparkCatalogName + "." + this.unkeyedTable.id().getDatabase() + "." + this.unkeyedTable.id().getTableName();
    }

    public Map<String, String> properties() {
        HashMap properties = Maps.newHashMap();
        properties.putAll(super.properties());
        properties.put("provider", MixedFormatSparkUtils.mixedTableProvider((MixedTable)this.table()));
        return properties;
    }

    public StructType partitionSchema() {
        return SparkSchemaUtil.convert((Schema)new Schema(this.table().spec().partitionType().fields()));
    }

    public void createPartition(InternalRow ident, Map<String, String> properties) throws PartitionAlreadyExistsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("not supported create partition");
    }

    public boolean dropPartition(InternalRow ident) {
        return false;
    }

    public void replacePartitionMetadata(InternalRow ident, Map<String, String> properties) throws NoSuchPartitionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("not supported replace partition");
    }

    public Map<String, String> loadPartitionMetadata(InternalRow ident) throws UnsupportedOperationException {
        return null;
    }

    public InternalRow[] listPartitionIdentifiers(String[] names, InternalRow ident) {
        return new InternalRow[0];
    }
}

