/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.writer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.spark.sql.connector.write.WriterCommitMessage;

public class WriteTaskCommit
implements WriterCommitMessage {
    private final DataFile[] dataFiles;
    private final DeleteFile[] deleteFiles;

    WriteTaskCommit(List<DataFile> dataFiles, List<DeleteFile> deleteFiles) {
        this.dataFiles = dataFiles.toArray(new DataFile[0]);
        this.deleteFiles = deleteFiles.toArray(new DeleteFile[0]);
    }

    DataFile[] files() {
        return this.dataFiles;
    }

    public static Iterable<DataFile> files(WriterCommitMessage[] messages) {
        if (messages.length > 0) {
            return Iterables.concat((Iterable)Iterables.transform(Arrays.asList(messages), message -> message != null ? ImmutableList.copyOf((Object[])((WriteTaskCommit)message).files()) : ImmutableList.of()));
        }
        return ImmutableList.of();
    }

    DeleteFile[] deleteFiles() {
        return this.deleteFiles;
    }

    public static Iterable<DeleteFile> deleteFiles(WriterCommitMessage[] messages) {
        if (messages.length > 0) {
            return Iterables.concat((Iterable)Iterables.transform(Arrays.asList(messages), message -> message != null ? ImmutableList.copyOf((Object[])((WriteTaskCommit)message).deleteFiles()) : ImmutableList.of()));
        }
        return ImmutableList.of();
    }

    public static class Builder {
        private final List<DataFile> dataFiles = new ArrayList<DataFile>();
        private final List<DeleteFile> deleteFiles = new ArrayList<DeleteFile>();

        Builder() {
        }

        public Builder add(WriteTaskCommit result) {
            this.addDataFiles(result.dataFiles);
            this.addDeleteFiles(result.deleteFiles);
            return this;
        }

        public Builder addAll(Iterable<WriteTaskCommit> results) {
            results.forEach(this::add);
            return this;
        }

        public Builder addDataFiles(DataFile ... files) {
            Collections.addAll(this.dataFiles, files);
            return this;
        }

        public Builder addDataFiles(Iterable<DataFile> files) {
            Iterables.addAll(this.dataFiles, files);
            return this;
        }

        public Builder addDeleteFiles(DeleteFile ... files) {
            Collections.addAll(this.deleteFiles, files);
            return this;
        }

        public Builder addDeleteFiles(Iterable<DeleteFile> files) {
            Iterables.addAll(this.deleteFiles, files);
            return this;
        }

        public WriteTaskCommit build() {
            return new WriteTaskCommit(this.dataFiles, this.deleteFiles);
        }
    }
}

