/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import java.net.InetAddress;
import org.apache.amoro.api.config.ConfigOption;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.dashboard.utils.AmsUtil;

public class AmoroManagementConfValidator {
    public static void validateConfig(Configurations configurations) {
        if ("".equals(configurations.getString(AmoroManagementConf.SERVER_EXPOSE_HOST))) {
            throw new IllegalArgumentException("configuration " + AmoroManagementConf.SERVER_EXPOSE_HOST.key() + " must be set");
        }
        InetAddress inetAddress = AmsUtil.lookForBindHost(configurations.getString(AmoroManagementConf.SERVER_EXPOSE_HOST));
        configurations.setString(AmoroManagementConf.SERVER_EXPOSE_HOST, inetAddress.getHostAddress());
        if (("mysql".equalsIgnoreCase(configurations.getString(AmoroManagementConf.DB_TYPE)) || "postgres".equalsIgnoreCase(configurations.getString(AmoroManagementConf.DB_TYPE))) && ("".equals(configurations.getString(AmoroManagementConf.DB_PASSWORD)) || "".equals(configurations.getString(AmoroManagementConf.DB_USER_NAME)))) {
            throw new IllegalArgumentException("username and password must be configured if the database type is mysql or postgres");
        }
        if (configurations.getBoolean(AmoroManagementConf.HA_ENABLE) && "".equals(configurations.getString(AmoroManagementConf.HA_ZOOKEEPER_ADDRESS))) {
            throw new IllegalArgumentException(AmoroManagementConf.HA_ZOOKEEPER_ADDRESS.key() + " must be configured when you enable the ams high availability");
        }
        String terminalBackend = configurations.getString(AmoroManagementConf.TERMINAL_BACKEND).toLowerCase();
        if (!AmoroManagementConf.TERMINAL_BACKEND_VALUES.contains(terminalBackend)) {
            throw new IllegalArgumentException(String.format("Illegal terminal implement: %s, local, kyuubi, custom is available", terminalBackend));
        }
        AmoroManagementConfValidator.validateThreadCount(configurations, AmoroManagementConf.REFRESH_TABLES_THREAD_COUNT);
        AmoroManagementConfValidator.validateThreadCount(configurations, AmoroManagementConf.OPTIMIZING_COMMIT_THREAD_COUNT);
        if (configurations.getBoolean(AmoroManagementConf.EXPIRE_SNAPSHOTS_ENABLED)) {
            AmoroManagementConfValidator.validateThreadCount(configurations, AmoroManagementConf.EXPIRE_SNAPSHOTS_THREAD_COUNT);
        }
        if (configurations.getBoolean(AmoroManagementConf.CLEAN_ORPHAN_FILES_ENABLED)) {
            AmoroManagementConfValidator.validateThreadCount(configurations, AmoroManagementConf.CLEAN_ORPHAN_FILES_THREAD_COUNT);
        }
        if (configurations.getBoolean(AmoroManagementConf.SYNC_HIVE_TABLES_ENABLED)) {
            AmoroManagementConfValidator.validateThreadCount(configurations, AmoroManagementConf.SYNC_HIVE_TABLES_THREAD_COUNT);
        }
    }

    private static void validateThreadCount(Configurations configurations, ConfigOption<Integer> config) {
        int threadCount = configurations.getInteger(config);
        if (threadCount <= 0) {
            throw new IllegalArgumentException(String.format("%s(%s) must > 0, actual value = %d", config.key(), config.description(), threadCount));
        }
    }
}

