/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import org.apache.amoro.AmoroTable;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.formats.mixed.MixedTable;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.server.catalog.InternalIcebergCatalogImpl;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalMixedIcebergCreator;
import org.apache.amoro.server.table.internal.InternalMixedIcebergHandler;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.BasicKeyedTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public class InternalMixedCatalogImpl
extends InternalIcebergCatalogImpl {
    protected InternalMixedCatalogImpl(CatalogMeta metadata, Configurations serverConfiguration) {
        super(metadata, serverConfiguration);
    }

    @Override
    protected InternalTableCreator newTableCreator(String database, String tableName, CreateTableRequest request) {
        return new InternalMixedIcebergCreator(this.getMetadata(), database, tableName, request);
    }

    @Override
    public <O> InternalTableHandler<O> newTableHandler(String database, String tableStoreName) {
        String tableName = this.tableName(tableStoreName);
        boolean isChangeStore = this.isChangeStoreName(tableStoreName);
        TableMetadata metadata = this.loadTableMetadata(database, tableName);
        Preconditions.checkState((metadata.getFormat() == this.format() ? 1 : 0) != 0, (String)"the catalog only support to handle %s table", (Object)this.format().name());
        return this.newTableStoreHandler(metadata, isChangeStore);
    }

    private InternalTableHandler<TableOperations> newTableStoreHandler(TableMetadata metadata, boolean isChangeStore) {
        return new InternalMixedIcebergHandler(this.getMetadata(), metadata, isChangeStore);
    }

    private String tableName(String tableStoreName) {
        if (this.isChangeStoreName(tableStoreName)) {
            return tableStoreName.substring(0, tableStoreName.length() - "@change".length());
        }
        return tableStoreName;
    }

    private boolean isChangeStoreName(String tableName) {
        String separator = "@";
        if (!tableName.contains(separator)) {
            return false;
        }
        Preconditions.checkArgument((tableName.indexOf(separator) == tableName.lastIndexOf(separator) && tableName.endsWith("@change") ? 1 : 0) != 0, (String)"illegal table name: %s, %s is not allowed in table name.", (Object)tableName, (Object)separator);
        return true;
    }

    @Override
    public AmoroTable<?> loadTable(String database, String tableName) {
        BasicUnkeyedTable mixedIcebergTable;
        Preconditions.checkArgument((!this.isChangeStoreName(tableName) ? 1 : 0) != 0, (Object)"table name is invalid for load table");
        TableMetadata tableMetadata = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaByName(this.getMetadata().getCatalogName(), database, tableName));
        if (tableMetadata == null) {
            return null;
        }
        Preconditions.checkArgument((TableFormat.MIXED_ICEBERG == tableMetadata.getFormat() ? 1 : 0) != 0, (String)"Table: %s.%s.%s is not a mixed-iceberg table", (Object)this.name(), (Object)database, (Object)tableName);
        org.apache.amoro.table.TableIdentifier tableIdentifier = org.apache.amoro.table.TableIdentifier.of((String)this.name(), (String)database, (String)tableName);
        AuthenticatedFileIO fileIO = InternalTableUtil.newIcebergFileIo(this.getMetadata());
        BaseTable baseTable = this.loadTableStore(tableMetadata, false);
        if (InternalTableUtil.isKeyedMixedTable(tableMetadata)) {
            BaseTable changeTable = this.loadTableStore(tableMetadata, true);
            PrimaryKeySpec.Builder keySpecBuilder = PrimaryKeySpec.builderFor((Schema)baseTable.schema());
            tableMetadata.buildTableMeta().getKeySpec().getFields().forEach(arg_0 -> ((PrimaryKeySpec.Builder)keySpecBuilder).addColumn(arg_0));
            PrimaryKeySpec keySpec = keySpecBuilder.build();
            mixedIcebergTable = new BasicKeyedTable(tableMetadata.getTableLocation(), keySpec, (org.apache.amoro.table.BaseTable)new BasicKeyedTable.BaseInternalTable(tableIdentifier, (Table)baseTable, fileIO, this.getMetadata().getCatalogProperties()), (ChangeTable)new BasicKeyedTable.ChangeInternalTable(tableIdentifier, (Table)changeTable, fileIO, this.getMetadata().getCatalogProperties()));
        } else {
            mixedIcebergTable = new BasicUnkeyedTable(tableIdentifier, (Table)baseTable, fileIO, this.getMetadata().getCatalogProperties());
        }
        return new MixedTable((org.apache.amoro.table.MixedTable)mixedIcebergTable, TableFormat.MIXED_ICEBERG);
    }

    @Override
    protected TableFormat format() {
        return TableFormat.MIXED_ICEBERG;
    }

    protected BaseTable loadTableStore(TableMetadata tableMetadata, boolean isChangeStore) {
        TableOperations ops = this.newTableStoreHandler(tableMetadata, isChangeStore).newTableOperator();
        return new BaseTable(ops, TableIdentifier.of((String[])new String[]{tableMetadata.getTableIdentifier().getDatabase(), tableMetadata.getTableIdentifier().getTableName()}).toString());
    }
}

