/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.model;

import java.util.Objects;
import org.apache.amoro.server.dashboard.utils.CommonUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class KafkaClusterSimpleInfo {
    private String name;
    private String zkAddress;
    private String brokerList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaClusterSimpleInfo that = (KafkaClusterSimpleInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.zkAddress, that.zkAddress) && Objects.equals(this.brokerList, that.brokerList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.zkAddress, this.brokerList);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("zkAddress", (Object)this.zkAddress).add("brokerList", (Object)this.brokerList).toString();
    }

    public void validate() {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)this.zkAddress) || StringUtils.isNotBlank((String)this.brokerList) ? 1 : 0) != 0, (Object)"both zk and broker address is blank");
        if (StringUtils.isNotBlank((String)this.brokerList)) {
            Preconditions.checkArgument((boolean)CommonUtil.telnetOrPing(this.brokerList), (Object)("telnet broker address timeout! " + this.brokerList));
        }
    }
}

