/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.api.config.OptimizingConfig;
import org.apache.amoro.optimizing.OptimizingInputProperties;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.server.optimizing.plan.CommonPartitionEvaluator;
import org.apache.amoro.server.optimizing.plan.PartitionEvaluator;
import org.apache.amoro.server.optimizing.plan.TaskDescriptor;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.MixedTableUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.Pair;

public abstract class AbstractPartitionPlan
implements PartitionEvaluator {
    protected final Pair<Integer, StructLike> partition;
    protected final OptimizingConfig config;
    protected final TableRuntime tableRuntime;
    private CommonPartitionEvaluator evaluator;
    private TaskSplitter taskSplitter;
    protected MixedTable tableObject;
    private Long fromSequence = null;
    private Long toSequence = null;
    protected final long planTime;
    protected final Map<DataFile, List<ContentFile<?>>> rewriteDataFiles = Maps.newHashMap();
    protected final Map<DataFile, List<ContentFile<?>>> undersizedSegmentFiles = Maps.newHashMap();
    protected final Map<DataFile, List<ContentFile<?>>> rewritePosDataFiles = Maps.newHashMap();
    protected final Set<String> reservedDeleteFiles = Sets.newHashSet();

    public AbstractPartitionPlan(TableRuntime tableRuntime, MixedTable table, Pair<Integer, StructLike> partition, long planTime) {
        this.partition = partition;
        this.tableObject = table;
        this.config = tableRuntime.getOptimizingConfig();
        this.tableRuntime = tableRuntime;
        this.planTime = planTime;
    }

    @Override
    public Pair<Integer, StructLike> getPartition() {
        return this.partition;
    }

    protected CommonPartitionEvaluator evaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.buildEvaluator();
        }
        return this.evaluator;
    }

    protected CommonPartitionEvaluator buildEvaluator() {
        return new CommonPartitionEvaluator(this.tableRuntime, this.partition, this.planTime);
    }

    @Override
    public boolean isNecessary() {
        return this.evaluator().isNecessary();
    }

    @Override
    public OptimizingType getOptimizingType() {
        return this.evaluator().getOptimizingType();
    }

    @Override
    public long getCost() {
        return this.evaluator().getCost();
    }

    @Override
    public boolean addFile(DataFile dataFile, List<ContentFile<?>> deletes) {
        boolean added = this.evaluator().addFile(dataFile, deletes);
        if (added) {
            if (this.evaluator().fileShouldRewrite(dataFile, deletes)) {
                this.rewriteDataFiles.put(dataFile, deletes);
            } else if (this.evaluator().isUndersizedSegmentFile(dataFile)) {
                this.undersizedSegmentFiles.put(dataFile, deletes);
            } else if (this.evaluator().segmentShouldRewritePos(dataFile, deletes)) {
                this.rewritePosDataFiles.put(dataFile, deletes);
            } else {
                added = false;
            }
        }
        if (!added) {
            this.reservedDeleteFiles(deletes);
        }
        return added;
    }

    protected void reservedDeleteFiles(List<ContentFile<?>> deletes) {
        deletes.stream().map(delete -> delete.path().toString()).forEach(this.reservedDeleteFiles::add);
    }

    public List<TaskDescriptor> splitTasks(int targetTaskCount) {
        if (this.taskSplitter == null) {
            this.taskSplitter = this.buildTaskSplitter();
        }
        this.beforeSplit();
        return this.filterSplitTasks(this.taskSplitter.splitTasks(targetTaskCount)).stream().map(task -> task.buildTask(this.buildTaskProperties())).collect(Collectors.toList());
    }

    protected void beforeSplit() {
    }

    protected List<SplitTask> filterSplitTasks(List<SplitTask> splitTasks) {
        return splitTasks;
    }

    protected abstract TaskSplitter buildTaskSplitter();

    protected abstract OptimizingInputProperties buildTaskProperties();

    protected void markSequence(long sequence) {
        if (this.fromSequence == null || this.fromSequence > sequence) {
            this.fromSequence = sequence;
        }
        if (this.toSequence == null || this.toSequence < sequence) {
            this.toSequence = sequence;
        }
    }

    public Long getFromSequence() {
        return this.fromSequence;
    }

    public Long getToSequence() {
        return this.toSequence;
    }

    @Override
    public int getFragmentFileCount() {
        return this.evaluator().getFragmentFileCount();
    }

    @Override
    public long getFragmentFileSize() {
        return this.evaluator().getFragmentFileSize();
    }

    @Override
    public int getSegmentFileCount() {
        return this.evaluator().getSegmentFileCount();
    }

    @Override
    public long getSegmentFileSize() {
        return this.evaluator().getSegmentFileSize();
    }

    @Override
    public int getEqualityDeleteFileCount() {
        return this.evaluator().getEqualityDeleteFileCount();
    }

    @Override
    public long getEqualityDeleteFileSize() {
        return this.evaluator().getEqualityDeleteFileSize();
    }

    @Override
    public int getPosDeleteFileCount() {
        return this.evaluator().getPosDeleteFileCount();
    }

    @Override
    public long getPosDeleteFileSize() {
        return this.evaluator().getPosDeleteFileSize();
    }

    @Override
    public PartitionEvaluator.Weight getWeight() {
        return this.evaluator().getWeight();
    }

    protected void disposeUndersizedSegmentFile(SplitTask splitTask) {
        Optional dataFile = splitTask.getRewriteDataFiles().stream().findFirst();
        if (dataFile.isPresent()) {
            DataFile rewriteDataFile = (DataFile)dataFile.get();
            ArrayList deletes = new ArrayList(splitTask.getDeleteFiles());
            if (this.evaluator().segmentShouldRewritePos(rewriteDataFile, deletes)) {
                this.rewritePosDataFiles.put(rewriteDataFile, deletes);
            } else {
                this.reservedDeleteFiles(deletes);
            }
        }
    }

    protected static interface TaskSplitter {
        public List<SplitTask> splitTasks(int var1);
    }

    protected class SplitTask {
        private final Set<DataFile> rewriteDataFiles = Sets.newHashSet();
        private final Set<DataFile> rewritePosDataFiles = Sets.newHashSet();
        private final Set<ContentFile<?>> deleteFiles = Sets.newHashSet();

        public SplitTask(Set<DataFile> rewriteDataFiles, Set<DataFile> rewritePosDataFiles, Set<ContentFile<?>> deleteFiles) {
            this.rewriteDataFiles.addAll(rewriteDataFiles);
            this.rewritePosDataFiles.addAll(rewritePosDataFiles);
            this.deleteFiles.addAll(deleteFiles);
        }

        public Set<DataFile> getRewriteDataFiles() {
            return this.rewriteDataFiles;
        }

        public Set<ContentFile<?>> getDeleteFiles() {
            return this.deleteFiles;
        }

        public Set<DataFile> getRewritePosDataFiles() {
            return this.rewritePosDataFiles;
        }

        public TaskDescriptor buildTask(OptimizingInputProperties properties) {
            HashSet readOnlyDeleteFiles = Sets.newHashSet();
            HashSet rewriteDeleteFiles = Sets.newHashSet();
            for (ContentFile<?> deleteFile : this.deleteFiles) {
                if (AbstractPartitionPlan.this.reservedDeleteFiles.contains(deleteFile.path().toString())) {
                    readOnlyDeleteFiles.add(deleteFile);
                    continue;
                }
                rewriteDeleteFiles.add(deleteFile);
            }
            RewriteFilesInput input = new RewriteFilesInput(this.rewriteDataFiles.toArray(new DataFile[0]), this.rewritePosDataFiles.toArray(new DataFile[0]), readOnlyDeleteFiles.toArray(new ContentFile[0]), rewriteDeleteFiles.toArray(new ContentFile[0]), AbstractPartitionPlan.this.tableObject);
            PartitionSpec spec = MixedTableUtil.getMixedTablePartitionSpecById((MixedTable)AbstractPartitionPlan.this.tableObject, (int)((Integer)AbstractPartitionPlan.this.partition.first()));
            String partitionPath = spec.partitionToPath((StructLike)AbstractPartitionPlan.this.partition.second());
            return new TaskDescriptor(AbstractPartitionPlan.this.tableRuntime.getTableIdentifier().getId(), partitionPath, input, properties.getProperties());
        }
    }

    protected class BinPackingTaskSplitter
    implements TaskSplitter {
        protected BinPackingTaskSplitter() {
        }

        @Override
        public List<SplitTask> splitTasks(int targetTaskCount) {
            ArrayList results = Lists.newArrayList();
            ArrayList fileTasks = Lists.newArrayList();
            AbstractPartitionPlan.this.undersizedSegmentFiles.forEach((dataFile, deleteFiles) -> fileTasks.add(new FileTask((DataFile)dataFile, (List<ContentFile<?>>)deleteFiles, true)));
            for (SplitTask splitTask : this.genSplitTasks(fileTasks)) {
                if (splitTask.getRewriteDataFiles().size() > 1) {
                    results.add(splitTask);
                    continue;
                }
                AbstractPartitionPlan.this.disposeUndersizedSegmentFile(splitTask);
            }
            fileTasks.clear();
            AbstractPartitionPlan.this.rewriteDataFiles.forEach((dataFile, deleteFiles) -> fileTasks.add(new FileTask((DataFile)dataFile, (List<ContentFile<?>>)deleteFiles, true)));
            AbstractPartitionPlan.this.rewritePosDataFiles.forEach((dataFile, deleteFiles) -> fileTasks.add(new FileTask((DataFile)dataFile, (List<ContentFile<?>>)deleteFiles, false)));
            results.addAll(this.genSplitTasks(fileTasks));
            return results;
        }

        private Collection<? extends SplitTask> genSplitTasks(List<FileTask> allDataFiles) {
            List packed = new BinPacking.ListPacker(Math.max(AbstractPartitionPlan.this.config.getTargetSize(), AbstractPartitionPlan.this.config.getMaxTaskSize()), Integer.MAX_VALUE, false).pack(allDataFiles, f -> f.getFile().fileSizeInBytes());
            ArrayList results = Lists.newArrayListWithCapacity((int)packed.size());
            for (List fileTasks : packed) {
                HashSet rewriteDataFiles = Sets.newHashSet();
                HashSet rewritePosDataFiles = Sets.newHashSet();
                HashSet deleteFiles = Sets.newHashSet();
                fileTasks.stream().filter(FileTask::isRewriteDataFile).forEach(f -> {
                    rewriteDataFiles.add(f.getFile());
                    deleteFiles.addAll(f.getDeleteFiles());
                });
                fileTasks.stream().filter(FileTask::isRewritePosDataFile).forEach(f -> {
                    rewritePosDataFiles.add(f.getFile());
                    deleteFiles.addAll(f.getDeleteFiles());
                });
                results.add(new SplitTask(rewriteDataFiles, rewritePosDataFiles, deleteFiles));
            }
            return results;
        }
    }

    protected static class FileTask {
        private final DataFile file;
        private final List<ContentFile<?>> deleteFiles;
        private final boolean isRewriteDataFile;

        public FileTask(DataFile file, List<ContentFile<?>> deleteFiles, boolean isRewriteDataFile) {
            this.file = file;
            this.deleteFiles = deleteFiles;
            this.isRewriteDataFile = isRewriteDataFile;
        }

        public DataFile getFile() {
            return this.file;
        }

        public List<ContentFile<?>> getDeleteFiles() {
            return this.deleteFiles;
        }

        public boolean isRewriteDataFile() {
            return this.isRewriteDataFile;
        }

        public boolean isRewritePosDataFile() {
            return !this.isRewriteDataFile;
        }
    }
}

