/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.server.dashboard.utils.PropertiesUtil;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableMetaStore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TableMetadata
implements Serializable {
    private ServerTableIdentifier tableIdentifier;
    private String tableLocation;
    private String baseLocation;
    private String changeLocation;
    private String primaryKey;
    private String metaStoreSite;
    private String hdfsSite;
    private String coreSite;
    private String authMethod;
    private String hadoopUsername;
    private String krbKeytab;
    private String krbConf;
    private String krbPrincipal;
    private Map<String, String> properties;
    private long metaVersion;
    private volatile TableMetaStore metaStore;

    private TableMetadata() {
    }

    public TableMetadata(ServerTableIdentifier identifier, TableMeta tableMeta, CatalogMeta catalogMeta) {
        this.tableIdentifier = identifier;
        HashMap properties = Maps.newHashMap((Map)tableMeta.getProperties());
        Preconditions.checkNotNull((Object)tableMeta.getFormat(), (Object)"lack require field: table format");
        if (tableMeta.getLocations() != null && tableMeta.getLocations().containsKey("table")) {
            this.tableLocation = (String)tableMeta.getLocations().get("table");
        }
        if (tableMeta.getLocations() != null && tableMeta.getLocations().containsKey("base")) {
            this.baseLocation = (String)tableMeta.getLocations().get("base");
        }
        if (tableMeta.getLocations() != null && tableMeta.getLocations().containsKey("change")) {
            this.changeLocation = (String)tableMeta.getLocations().get("change");
        }
        if (StringUtils.isBlank((String)this.tableLocation) || StringUtils.isBlank((String)this.baseLocation)) {
            throw new IllegalArgumentException("table location is required");
        }
        this.primaryKey = tableMeta.getKeySpec() == null || CollectionUtils.isEmpty((Collection)tableMeta.getKeySpec().getFields()) ? PrimaryKeySpec.noPrimaryKey().description() : String.join((CharSequence)",", tableMeta.getKeySpec().getFields());
        this.metaStoreSite = (String)catalogMeta.getStorageConfigs().get("hive.site");
        this.hdfsSite = (String)catalogMeta.getStorageConfigs().get("hadoop.hdfs.site");
        this.coreSite = (String)catalogMeta.getStorageConfigs().get("hadoop.core.site");
        this.authMethod = (String)catalogMeta.getAuthConfigs().get("auth.type");
        if (this.authMethod != null) {
            this.authMethod = this.authMethod.toUpperCase(Locale.ROOT);
        }
        this.hadoopUsername = (String)catalogMeta.getAuthConfigs().get("auth.simple.hadoop_username");
        this.krbKeytab = (String)catalogMeta.getAuthConfigs().get("auth.kerberos.keytab");
        this.krbConf = (String)catalogMeta.getAuthConfigs().get("auth.kerberos.krb5");
        this.krbPrincipal = (String)catalogMeta.getAuthConfigs().get("auth.kerberos.principal");
        this.properties = properties;
    }

    public TableMeta buildTableMeta() {
        TableMeta meta = new TableMeta();
        meta.setTableIdentifier(this.tableIdentifier.getIdentifier());
        HashMap<String, String> locations = new HashMap<String, String>();
        PropertiesUtil.putNotNullProperties(locations, "table", this.tableLocation);
        PropertiesUtil.putNotNullProperties(locations, "change", this.changeLocation);
        PropertiesUtil.putNotNullProperties(locations, "base", this.baseLocation);
        meta.setLocations(locations);
        HashMap<String, String> newProperties = new HashMap<String, String>(this.properties);
        meta.setProperties(newProperties);
        if (StringUtils.isNotBlank((String)this.primaryKey)) {
            org.apache.amoro.api.PrimaryKeySpec keySpec = new org.apache.amoro.api.PrimaryKeySpec();
            List fields = Arrays.stream(this.primaryKey.split(",")).collect(Collectors.toList());
            keySpec.setFields(fields);
            meta.setKeySpec(keySpec);
        }
        meta.setFormat(this.getFormat().name());
        return meta;
    }

    public TableFormat getFormat() {
        return this.tableIdentifier.getFormat();
    }

    public String getTableLocation() {
        return this.tableLocation;
    }

    public void setTableLocation(String tableLocation) {
        this.tableLocation = tableLocation;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public String getChangeLocation() {
        return this.changeLocation;
    }

    public void setChangeLocation(String changeLocation) {
        this.changeLocation = changeLocation;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetaStore getMetaStore() {
        if (this.metaStore == null) {
            TableMetadata tableMetadata = this;
            synchronized (tableMetadata) {
                if (this.metaStore == null) {
                    this.metaStore = TableMetaStore.builder().withBase64MetaStoreSite(this.metaStoreSite).withBase64CoreSite(this.coreSite).withBase64HdfsSite(this.hdfsSite).withBase64Auth(this.authMethod, this.hadoopUsername, this.krbKeytab, this.krbConf, this.krbPrincipal).build();
                }
            }
        }
        return this.metaStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void setMetaStore(TableMetaStore metaStore) {
        TableMetadata tableMetadata = this;
        synchronized (tableMetadata) {
            this.metaStore = metaStore;
        }
    }

    public String getMetaStoreSite() {
        return this.metaStoreSite;
    }

    public void setMetaStoreSite(String metaStoreSite) {
        this.metaStoreSite = metaStoreSite;
    }

    public String getHdfsSite() {
        return this.hdfsSite;
    }

    public void setHdfsSite(String hdfsSite) {
        this.hdfsSite = hdfsSite;
    }

    public String getCoreSite() {
        return this.coreSite;
    }

    public void setCoreSite(String coreSite) {
        this.coreSite = coreSite;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getHadoopUsername() {
        return this.hadoopUsername;
    }

    public void setHadoopUsername(String hadoopUsername) {
        this.hadoopUsername = hadoopUsername;
    }

    public String getKrbKeytab() {
        return this.krbKeytab;
    }

    public void setKrbKeytab(String krbKeytab) {
        this.krbKeytab = krbKeytab;
    }

    public String getKrbConf() {
        return this.krbConf;
    }

    public void setKrbConf(String krbConf) {
        this.krbConf = krbConf;
    }

    public String getKrbPrincipal() {
        return this.krbPrincipal;
    }

    public void setKrbPrincipal(String krbPrincipal) {
        this.krbPrincipal = krbPrincipal;
    }

    public long getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(long metaVersion) {
        this.metaVersion = metaVersion;
    }
}

