/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.security;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.security.HadoopFSDelegationTokenProvider$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.security.HadoopDelegationTokenProvider;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!B\t\u0013\u0001Qa\u0002\"\u0002\u0018\u0001\t\u0003\u0001\u0004bB\u001a\u0001\u0001\u0004%I\u0001\u000e\u0005\bw\u0001\u0001\r\u0011\"\u0003=\u0011\u0019\u0011\u0005\u0001)Q\u0005k!91\t\u0001b\u0001\n\u0003\"\u0005B\u0002)\u0001A\u0003%Q\tC\u0003R\u0001\u0011\u0005#\u000bC\u0003k\u0001\u0011\u00053\u000eC\u0003r\u0001\u0011%!\u000fC\u0003v\u0001\u0011%a\u000fC\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e\u001dA\u0011q\u0007\n\t\u0002Q\tIDB\u0004\u0012%!\u0005A#a\u000f\t\r9rA\u0011AA\u001f\u0011\u001d\tyD\u0004C\u0001\u0003\u0003\u0012q\u0004S1e_>\u0004hi\u0015#fY\u0016<\u0017\r^5p]R{7.\u001a8Qe>4\u0018\u000eZ3s\u0015\t\u0019B#\u0001\u0005tK\u000e,(/\u001b;z\u0015\t)b#\u0001\u0004eKBdw.\u001f\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sON!\u0001!H\u0012)!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0011AEJ\u0007\u0002K)\u00111CF\u0005\u0003O\u0015\u0012Q\u0004S1e_>\u0004H)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000e\u0015:pm&$WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003WY\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003[)\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005\u0011\u0012\u0001\u0006;pW\u0016t'+\u001a8fo\u0006d\u0017J\u001c;feZ\fG.F\u00016!\rqb\u0007O\u0005\u0003o}\u0011aa\u00149uS>t\u0007C\u0001\u0010:\u0013\tQtD\u0001\u0003M_:<\u0017\u0001\u0007;pW\u0016t'+\u001a8fo\u0006d\u0017J\u001c;feZ\fGn\u0018\u0013fcR\u0011Q\b\u0011\t\u0003=yJ!aP\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000e\t\t\u00111\u00016\u0003\rAH%M\u0001\u0016i>\\WM\u001c*f]\u0016<\u0018\r\\%oi\u0016\u0014h/\u00197!\u0003-\u0019XM\u001d<jG\u0016t\u0015-\\3\u0016\u0003\u0015\u0003\"AR'\u000f\u0005\u001d[\u0005C\u0001% \u001b\u0005I%B\u0001&0\u0003\u0019a$o\\8u}%\u0011AjH\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M?\u0005a1/\u001a:wS\u000e,g*Y7fA\u00051rN\u0019;bS:$U\r\\3hCRLwN\u001c+pW\u0016t7\u000f\u0006\u00036'v\u001b\u0007\"\u0002+\b\u0001\u0004)\u0016A\u00035bI>|\u0007oQ8oMB\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0005G>tgM\u0003\u0002[1\u00051\u0001.\u00193p_BL!\u0001X,\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015qv\u00011\u0001`\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002aC6\ta#\u0003\u0002c-\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006I\u001e\u0001\r!Z\u0001\u0006GJ,Gm\u001d\t\u0003M\"l\u0011a\u001a\u0006\u0003'eK!![4\u0003\u0017\r\u0013X\rZ3oi&\fGn]\u0001\u0019I\u0016dWmZ1uS>tGk\\6f]N\u0014V-];je\u0016$Gc\u00017paB\u0011a$\\\u0005\u0003]~\u0011qAQ8pY\u0016\fg\u000eC\u0003_\u0011\u0001\u0007q\fC\u0003U\u0011\u0001\u0007Q+A\bhKR$vn[3o%\u0016tWm^3s)\r)5\u000f\u001e\u0005\u0006=&\u0001\ra\u0018\u0005\u0006)&\u0001\r!V\u0001\u0016M\u0016$8\r\u001b#fY\u0016<\u0017\r^5p]R{7.\u001a8t)\u001d)w/_A\u0005\u0003\u0017AQ\u0001\u001f\u0006A\u0002\u0015\u000bqA]3oK^,'\u000fC\u0003{\u0015\u0001\u000710A\u0006gS2,7/_:uK6\u001c\bc\u0001$}}&\u0011Qp\u0014\u0002\u0004'\u0016$\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007I\u0016A\u00014t\u0013\u0011\t9!!\u0001\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0003e\u0015\u0001\u0007Q\rC\u0004\u0002\u000e)\u0001\r!a\u0004\u0002\u0017\u0019\u001cHk\\#yG2,H-\u001a\t\u0004\rr,\u0015aF4fiR{7.\u001a8SK:,w/\u00197J]R,'O^1m)\u001d)\u0014QCA\f\u00033AQ\u0001V\u0006A\u0002UCQAX\u0006A\u0002}CQA_\u0006A\u0002m\fAbZ3u\u0013N\u001cX/\u001a#bi\u0016$R\u0001OA\u0010\u0003GAa!!\t\r\u0001\u0004)\u0015\u0001B6j]\u0012Dq!!\n\r\u0001\u0004\t9#\u0001\u0006jI\u0016tG/\u001b4jKJ\u0004B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0006eK2,w-\u0019;j_:T1!!\rh\u0003\u0015!xn[3o\u0013\u0011\t)$a\u000b\u0003C\u0005\u00137\u000f\u001e:bGR$U\r\\3hCRLwN\u001c+pW\u0016t\u0017\nZ3oi&4\u0017.\u001a:\u0002?!\u000bGm\\8q\rN#U\r\\3hCRLwN\u001c+pW\u0016t\u0007K]8wS\u0012,'\u000f\u0005\u00023\u001dM\u0011a\"\b\u000b\u0003\u0003s\t\u0011\u0003[1e_>\u0004hiU:U_\u0006\u001b7-Z:t)\u0015Y\u00181IA#\u0011\u0015q\u0006\u00031\u0001`\u0011\u0015!\u0006\u00031\u0001V\u0001")
public class HadoopFSDelegationTokenProvider
implements HadoopDelegationTokenProvider,
Logging {
    private Option<Object> tokenRenewalInterval;
    private final String serviceName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Set<FileSystem> hadoopFSsToAccess(SparkConf sparkConf, Configuration configuration) {
        return HadoopFSDelegationTokenProvider$.MODULE$.hadoopFSsToAccess(sparkConf, configuration);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> tokenRenewalInterval() {
        return this.tokenRenewalInterval;
    }

    private void tokenRenewalInterval_$eq(Option<Object> x$1) {
        this.tokenRenewalInterval = x$1;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public Option<Object> obtainDelegationTokens(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        None$ none$;
        try {
            Set<FileSystem> fileSystems = HadoopFSDelegationTokenProvider$.MODULE$.hadoopFSsToAccess(sparkConf, hadoopConf);
            Set fsToExclude = ((TraversableOnce)((TraversableLike)sparkConf.get(package$.MODULE$.YARN_KERBEROS_FILESYSTEM_RENEWAL_EXCLUDE())).map((Function1 & Serializable & scala.Serializable)x$1 -> new Path(x$1).getFileSystem(hadoopConf).getUri().getHost(), Seq$.MODULE$.canBuildFrom())).toSet();
            Credentials fetchCreds = this.fetchDelegationTokens(this.getTokenRenewer(sparkConf, hadoopConf), fileSystems, creds, (Set<String>)fsToExclude);
            if (this.tokenRenewalInterval() == null) {
                this.tokenRenewalInterval_$eq(this.getTokenRenewalInterval(hadoopConf, sparkConf, fileSystems));
            }
            Option nextRenewalDate = this.tokenRenewalInterval().flatMap((Function1 & Serializable & scala.Serializable)interval -> HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$2(this, fetchCreds, BoxesRunTime.unboxToLong((Object)interval)));
            none$ = nextRenewalDate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to get token from service ").append(this.serviceName()).toString(), e);
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    @Override
    public boolean delegationTokensRequired(SparkConf sparkConf, Configuration hadoopConf) {
        return UserGroupInformation.isSecurityEnabled();
    }

    private String getTokenRenewer(SparkConf sparkConf, Configuration hadoopConf) {
        String master = sparkConf.get("spark.master", null);
        String tokenRenewer = master != null && master.contains("yarn") ? Master.getMasterPrincipal((Configuration)hadoopConf) : UserGroupInformation.getCurrentUser().getUserName();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Delegation token renewer is: ").append(tokenRenewer).toString());
        if (tokenRenewer == null || tokenRenewer.length() == 0) {
            String errorMessage = "Can't get Master Kerberos principal for use as renewer.";
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            throw new SparkException(errorMessage);
        }
        return tokenRenewer;
    }

    private Credentials fetchDelegationTokens(String renewer, Set<FileSystem> filesystems, Credentials creds, Set<String> fsToExclude) {
        filesystems.foreach((Function1 & Serializable & scala.Serializable)fs -> {
            Token[] tokenArray;
            if (fsToExclude.contains((Object)fs.getUri().getHost())) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("getting token for: ").append(fs).append(" with empty renewer to skip renewal").toString());
                tokenArray = fs.addDelegationTokens("", creds);
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("getting token for: ").append(fs).append(" with renewer ").append(renewer).toString());
                tokenArray = fs.addDelegationTokens(renewer, creds);
            }
            return tokenArray;
        });
        return creds;
    }

    private Option<Object> getTokenRenewalInterval(Configuration hadoopConf, SparkConf sparkConf, Set<FileSystem> filesystems) {
        String renewer = UserGroupInformation.getCurrentUser().getUserName();
        Credentials creds = new Credentials();
        this.fetchDelegationTokens(renewer, filesystems, creds, (Set<String>)Predef$.MODULE$.Set().empty());
        Iterable renewIntervals = (Iterable)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(creds.getAllTokens()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HadoopFSDelegationTokenProvider.$anonfun$getTokenRenewalInterval$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)token -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long newExpiration = token.renew(hadoopConf);
            AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
            String tokenKind = token.getKind().toString();
            long interval = newExpiration - this.getIssueDate(tokenKind, identifier);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Renewal interval is ").append(interval).append(" for token ").append(tokenKind).toString());
            return interval;
        }).toOption()), Iterable$.MODULE$.canBuildFrom());
        return renewIntervals.isEmpty() ? None$.MODULE$ : new Some(renewIntervals.min((Ordering)Ordering.Long$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private long getIssueDate(String kind, AbstractDelegationTokenIdentifier identifier) {
        long l;
        long now = System.currentTimeMillis();
        long issueDate = identifier.getIssueDate();
        if (issueDate > now) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(244).append("Token ").append(kind).append(" has set up issue date later than current time. (provided: ").append(issueDate).append(" / current timestamp: ").append(now).append(") Please make sure clocks are in sync between ").append("machines. If the issue is not a clock mismatch, consult token implementor to check ").append("whether issue date is valid.").toString());
            l = issueDate;
        } else if (issueDate > 0L) {
            l = issueDate;
        } else {
            void var3_3;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(152).append("Token ").append(kind).append(" has not set up issue date properly. (provided: ").append(issueDate).append(") ").append("Using current timestamp (").append(now).append(") as issue date instead. Consult token implementor to fix ").append("the behavior.").toString());
            l = var3_3;
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$obtainDelegationTokens$3(Token x$2) {
        return x$2.decodeIdentifier() instanceof AbstractDelegationTokenIdentifier;
    }

    public static final /* synthetic */ long $anonfun$obtainDelegationTokens$4(HadoopFSDelegationTokenProvider $this, long interval$1, Token token) {
        AbstractDelegationTokenIdentifier identifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        String tokenKind = token.getKind().toString();
        return $this.getIssueDate(tokenKind, identifier) + interval$1;
    }

    public static final /* synthetic */ Option $anonfun$obtainDelegationTokens$2(HadoopFSDelegationTokenProvider $this, Credentials fetchCreds$1, long interval) {
        Iterable nextRenewalDates = (Iterable)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(fetchCreds$1.getAllTokens()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$3(x$2)))).map((Function1 & Serializable & scala.Serializable)token -> BoxesRunTime.boxToLong((long)HadoopFSDelegationTokenProvider.$anonfun$obtainDelegationTokens$4($this, interval, token)), Iterable$.MODULE$.canBuildFrom());
        return nextRenewalDates.isEmpty() ? None$.MODULE$ : new Some(nextRenewalDates.min((Ordering)Ordering.Long$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$getTokenRenewalInterval$1(Token x$3) {
        return x$3.decodeIdentifier() instanceof AbstractDelegationTokenIdentifier;
    }

    public HadoopFSDelegationTokenProvider() {
        Logging.$init$(this);
        this.tokenRenewalInterval = null;
        this.serviceName = "hadoopfs";
    }
}

