/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.exception.ExceptionUtil;
import org.apache.bifromq.baserpc.client.loadbalancer.ChannelList;
import org.apache.bifromq.baserpc.client.loadbalancer.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubChannelPicker
extends LoadBalancer.SubchannelPicker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubChannelPicker.class);
    private final Map<String, ChannelList> serverChannels = new HashMap<String, ChannelList>();

    public void refresh(Map<String, ChannelList> serverChannels) {
        this.serverChannels.clear();
        serverChannels.forEach((serverId, channelList) -> this.serverChannels.put((String)serverId, channelList.copy()));
    }

    public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs pickSubchannelArgs) {
        String desiredServerId = (String)pickSubchannelArgs.getHeaders().get(Constants.DESIRED_SERVER_META_KEY);
        if (desiredServerId != null && this.serverChannels.containsKey(desiredServerId)) {
            log.trace("Direct pick sub-channel by serverId:{}", (Object)desiredServerId);
            pickSubchannelArgs.getHeaders().remove(Constants.DESIRED_SERVER_META_KEY, (Object)desiredServerId);
            Optional<LoadBalancer.Subchannel> selectedSubChannel = this.getSubChannel(desiredServerId);
            return selectedSubChannel.map(LoadBalancer.PickResult::withSubchannel).orElseGet(() -> LoadBalancer.PickResult.withError((Status)ExceptionUtil.SERVER_UNREACHABLE));
        }
        return LoadBalancer.PickResult.withError((Status)ExceptionUtil.SERVER_NOT_FOUND);
    }

    private Optional<LoadBalancer.Subchannel> getSubChannel(String serverId) {
        List<LoadBalancer.Subchannel> subChannels = this.serverChannels.get((Object)serverId).subChannels.stream().filter(sc -> ((ConnectivityStateInfo)((AtomicReference)sc.getAttributes().get(Constants.STATE_INFO)).get()).getState() == ConnectivityState.READY).toList();
        if (subChannels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(subChannels.get(ThreadLocalRandom.current().nextInt(subChannels.size())));
    }
}

