/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class StructProjection
implements StructLike {
    private final Types.StructType type;
    private final int[] positionMap;
    private final StructProjection[] nestedProjections;
    private StructLike struct;

    public static StructProjection create(Schema schema, Set<Integer> ids) {
        Types.StructType structType = schema.asStruct();
        return new StructProjection(structType, TypeUtil.project(structType, ids));
    }

    public static StructProjection create(Schema dataSchema, Schema projectedSchema) {
        return new StructProjection(dataSchema.asStruct(), projectedSchema.asStruct());
    }

    public static StructProjection create(Types.StructType structType, Types.StructType projectedStructType) {
        return new StructProjection(structType, projectedStructType);
    }

    public static StructProjection createAllowMissing(Types.StructType structType, Types.StructType projectedStructType) {
        return new StructProjection(structType, projectedStructType, true);
    }

    private StructProjection(Types.StructType type, int[] positionMap, StructProjection[] nestedProjections) {
        this.type = type;
        this.positionMap = positionMap;
        this.nestedProjections = nestedProjections;
    }

    private StructProjection(Types.StructType structType, Types.StructType projection) {
        this(structType, projection, false);
    }

    private StructProjection(Types.StructType structType, Types.StructType projection, boolean allowMissing) {
        this.type = projection;
        this.positionMap = new int[projection.fields().size()];
        this.nestedProjections = new StructProjection[projection.fields().size()];
        List<Types.NestedField> dataFields = structType.fields();
        for (int pos = 0; pos < this.positionMap.length; ++pos) {
            Types.NestedField projectedField = projection.fields().get(pos);
            boolean found = false;
            block6: for (int i = 0; !found && i < dataFields.size(); ++i) {
                Types.NestedField dataField = dataFields.get(i);
                if (projectedField.fieldId() != dataField.fieldId()) continue;
                found = true;
                this.positionMap[pos] = i;
                switch (projectedField.type().typeId()) {
                    case STRUCT: {
                        this.nestedProjections[pos] = new StructProjection(dataField.type().asStructType(), projectedField.type().asStructType());
                        continue block6;
                    }
                    case MAP: {
                        Types.MapType projectedMap = projectedField.type().asMapType();
                        Types.MapType originalMap = dataField.type().asMapType();
                        boolean keyProjectable = !projectedMap.keyType().isNestedType() || projectedMap.keyType().equals(originalMap.keyType());
                        boolean valueProjectable = !projectedMap.valueType().isNestedType() || projectedMap.valueType().equals(originalMap.valueType());
                        Preconditions.checkArgument((keyProjectable && valueProjectable ? 1 : 0) != 0, (String)"Cannot project a partial map key or value struct. Trying to project %s out of %s", (Object)projectedField, (Object)dataField);
                        this.nestedProjections[pos] = null;
                        continue block6;
                    }
                    case LIST: {
                        Types.ListType projectedList = projectedField.type().asListType();
                        Types.ListType originalList = dataField.type().asListType();
                        boolean elementProjectable = !projectedList.elementType().isNestedType() || projectedList.elementType().equals(originalList.elementType());
                        Preconditions.checkArgument((boolean)elementProjectable, (String)"Cannot project a partial list element struct. Trying to project %s out of %s", (Object)projectedField, (Object)dataField);
                        this.nestedProjections[pos] = null;
                        continue block6;
                    }
                    default: {
                        this.nestedProjections[pos] = null;
                    }
                }
            }
            if (!found && projectedField.isOptional() && allowMissing) {
                this.positionMap[pos] = -1;
                this.nestedProjections[pos] = null;
                continue;
            }
            if (found) continue;
            throw new IllegalArgumentException(String.format("Cannot find field %s in %s", projectedField, structType));
        }
    }

    public StructProjection wrap(StructLike newStruct) {
        this.struct = newStruct;
        return this;
    }

    public StructProjection copyFor(StructLike newStruct) {
        return new StructProjection(this.type, this.positionMap, this.nestedProjections).wrap(newStruct);
    }

    @Override
    public int size() {
        return this.type.fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        if (this.struct == null) {
            return null;
        }
        int structPos = this.positionMap[pos];
        if (this.nestedProjections[pos] != null) {
            StructLike nestedStruct = this.struct.get(structPos, StructLike.class);
            if (nestedStruct == null) {
                return null;
            }
            return javaClass.cast(this.nestedProjections[pos].wrap(nestedStruct));
        }
        if (structPos != -1) {
            return this.struct.get(structPos, javaClass);
        }
        return null;
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Cannot set fields in a TypeProjection");
    }
}

