/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Map;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTResponse;

public class LoadTableResponse
implements RESTResponse {
    private String metadataLocation;
    private TableMetadata metadata;
    private Map<String, String> config;

    public LoadTableResponse() {
    }

    private LoadTableResponse(String metadataLocation, TableMetadata metadata, Map<String, String> config) {
        this.metadataLocation = metadataLocation;
        this.metadata = metadata;
        this.config = config;
    }

    @Override
    public void validate() {
        Preconditions.checkNotNull((Object)this.metadata, (Object)"Invalid metadata: null");
    }

    public String metadataLocation() {
        return this.metadataLocation;
    }

    public TableMetadata tableMetadata() {
        return TableMetadata.buildFrom(this.metadata).withMetadataLocation(this.metadataLocation).build();
    }

    public Map<String, String> config() {
        return this.config != null ? this.config : ImmutableMap.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadataLocation", (Object)this.metadataLocation).add("metadata", (Object)this.metadata).add("config", this.config).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String metadataLocation;
        private TableMetadata metadata;
        private Map<String, String> config = Maps.newHashMap();

        private Builder() {
        }

        public Builder withTableMetadata(TableMetadata tableMetadata) {
            this.metadataLocation = tableMetadata.metadataFileLocation();
            this.metadata = tableMetadata;
            return this;
        }

        public Builder addConfig(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public Builder addAllConfig(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public LoadTableResponse build() {
            Preconditions.checkNotNull((Object)this.metadata, (Object)"Invalid metadata: null");
            return new LoadTableResponse(this.metadataLocation, this.metadata, this.config);
        }
    }
}

