/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.model.ModelVersion;

public final class EntityCombinedModelVersion
implements ModelVersion {
    private final ModelVersion modelVersion;
    private final ModelVersionEntity modelVersionEntity;
    private Set<String> hiddenProperties = Collections.emptySet();

    private EntityCombinedModelVersion(ModelVersion modelVersion, ModelVersionEntity modelVersionEntity) {
        this.modelVersion = modelVersion;
        this.modelVersionEntity = modelVersionEntity;
    }

    public static EntityCombinedModelVersion of(ModelVersion modelVersion, ModelVersionEntity modelVersionEntity) {
        return new EntityCombinedModelVersion(modelVersion, modelVersionEntity);
    }

    public static EntityCombinedModelVersion of(ModelVersion modelVersion) {
        return new EntityCombinedModelVersion(modelVersion, null);
    }

    public EntityCombinedModelVersion withHiddenProperties(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties;
        return this;
    }

    public int version() {
        return this.modelVersion.version();
    }

    public String comment() {
        return this.modelVersion.comment();
    }

    public Map<String, String> properties() {
        return this.modelVersion.properties() == null ? null : this.modelVersion.properties().entrySet().stream().filter(e -> !this.hiddenProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String uri() {
        return this.modelVersion.uri();
    }

    public String[] aliases() {
        return this.modelVersion.aliases();
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.modelVersion.auditInfo().creator()).withCreateTime(this.modelVersion.auditInfo().createTime()).withLastModifier(this.modelVersion.auditInfo().lastModifier()).withLastModifiedTime(this.modelVersion.auditInfo().lastModifiedTime()).build();
        return this.modelVersionEntity == null ? mergedAudit : mergedAudit.merge(this.modelVersionEntity.auditInfo(), true);
    }
}

