/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CapabilityHelpers;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public class TableNormalizeDispatcher
implements TableDispatcher {
    private final CatalogManager catalogManager;
    private final TableDispatcher dispatcher;

    public TableNormalizeDispatcher(TableDispatcher dispatcher, CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        Namespace caseSensitiveNs = this.normalizeCaseSensitive(namespace);
        NameIdentifier[] identifiers = this.dispatcher.listTables(caseSensitiveNs);
        return this.normalizeCaseSensitive(identifiers);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        return this.dispatcher.loadTable(this.normalizeCaseSensitive(ident));
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Capability capability = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return this.dispatcher.createTable(CapabilityHelpers.applyCapabilities(ident, Capability.Scope.TABLE, capability), CapabilityHelpers.applyCapabilities(columns, capability), comment, properties, CapabilityHelpers.applyCapabilities(partitions, capability), CapabilityHelpers.applyCapabilities(distribution, capability), CapabilityHelpers.applyCapabilities(sortOrders, capability), CapabilityHelpers.applyCapabilities(indexes, capability));
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        Capability capability = CapabilityHelpers.getCapability(ident, this.catalogManager);
        return this.dispatcher.alterTable(this.normalizeCaseSensitive(ident), CapabilityHelpers.applyCapabilities(capability, changes));
    }

    public boolean dropTable(NameIdentifier ident) {
        return this.dispatcher.dropTable(this.normalizeNameIdentifier(ident));
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        return this.dispatcher.purgeTable(this.normalizeNameIdentifier(ident));
    }

    public boolean tableExists(NameIdentifier ident) {
        return this.dispatcher.tableExists(this.normalizeCaseSensitive(ident));
    }

    private Namespace normalizeCaseSensitive(Namespace namespace) {
        Capability capabilities = CapabilityHelpers.getCapability(NameIdentifier.of((String[])namespace.levels()), this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(namespace, Capability.Scope.TABLE, capabilities);
    }

    private NameIdentifier normalizeCaseSensitive(NameIdentifier tableIdent) {
        Capability capability = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(tableIdent, Capability.Scope.TABLE, capability);
    }

    private NameIdentifier[] normalizeCaseSensitive(NameIdentifier[] tableIdents) {
        if (ArrayUtils.isEmpty((Object[])tableIdents)) {
            return tableIdents;
        }
        Capability capabilities = CapabilityHelpers.getCapability(tableIdents[0], this.catalogManager);
        return CapabilityHelpers.applyCaseSensitive(tableIdents, Capability.Scope.TABLE, capabilities);
    }

    private NameIdentifier normalizeNameIdentifier(NameIdentifier tableIdent) {
        Capability capability = CapabilityHelpers.getCapability(tableIdent, this.catalogManager);
        return CapabilityHelpers.applyCapabilities(tableIdent, Capability.Scope.TABLE, capability);
    }
}

