/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Map;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.PropertyEntry;

@Evolving
public interface PropertiesMetadata {
    public Map<String, PropertyEntry<?>> propertyEntries();

    default public boolean isReservedProperty(String propertyName) {
        return this.propertyEntries().containsKey(propertyName) && this.propertyEntries().get(propertyName).isReserved();
    }

    default public boolean isRequiredProperty(String propertyName) {
        return this.propertyEntries().containsKey(propertyName) && this.propertyEntries().get(propertyName).isRequired();
    }

    default public boolean isImmutableProperty(String propertyName) {
        return this.propertyEntries().containsKey(propertyName) && this.propertyEntries().get(propertyName).isImmutable();
    }

    default public boolean isHiddenProperty(String propertyName) {
        return this.propertyEntries().containsKey(propertyName) && this.propertyEntries().get(propertyName).isHidden();
    }

    default public boolean containsProperty(String propertyName) {
        return this.propertyEntries().containsKey(propertyName);
    }

    default public Object getOrDefault(Map<String, String> properties, String propertyName) {
        if (!this.containsProperty(propertyName)) {
            throw new IllegalArgumentException("Property is not defined: " + propertyName);
        }
        if (properties != null && properties.containsKey(propertyName)) {
            return this.propertyEntries().get(propertyName).decode(properties.get(propertyName));
        }
        return this.propertyEntries().get(propertyName).getDefaultValue();
    }

    default public Object getDefaultValue(String propertyName) {
        if (!this.containsProperty(propertyName)) {
            throw new IllegalArgumentException("Property is not defined: " + propertyName);
        }
        return this.propertyEntries().get(propertyName).getDefaultValue();
    }
}

