/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential.config;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class S3CredentialConfig
extends Config {
    public static final ConfigEntry<String> S3_REGION = new ConfigBuilder("s3-region").doc("The region of the S3 service").version("0.7.0").stringConf().create();
    public static final ConfigEntry<String> S3_ACCESS_KEY_ID = new ConfigBuilder("s3-access-key-id").doc("The static access key ID used to access S3 data").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> S3_SECRET_ACCESS_KEY = new ConfigBuilder("s3-secret-access-key").doc("The static secret access key used to access S3 data").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> S3_ROLE_ARN = new ConfigBuilder("s3-role-arn").doc("S3 role arn").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> S3_EXTERNAL_ID = new ConfigBuilder("s3-external-id").doc("S3 external ID").version("0.7.0").stringConf().create();
    public static final ConfigEntry<Integer> S3_TOKEN_EXPIRE_IN_SECS = new ConfigBuilder("s3-token-expire-in-secs").doc("S3 token expire in seconds").version("0.7.0").intConf().createWithDefault(3600);
    public static final ConfigEntry<String> S3_STS_ENDPOINT = new ConfigBuilder("s3-token-service-endpoint").doc("S3 STS endpoint").version("0.8.0").stringConf().create();

    public S3CredentialConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    @NotNull
    public String s3RoleArn() {
        return this.get(S3_ROLE_ARN);
    }

    @NotNull
    public String accessKeyID() {
        return this.get(S3_ACCESS_KEY_ID);
    }

    @NotNull
    public String secretAccessKey() {
        return this.get(S3_SECRET_ACCESS_KEY);
    }

    public String region() {
        return this.get(S3_REGION);
    }

    public String externalID() {
        return this.get(S3_EXTERNAL_ID);
    }

    public Integer tokenExpireInSecs() {
        return this.get(S3_TOKEN_EXPIRE_IN_SECS);
    }

    public String stsEndpoint() {
        return this.get(S3_STS_ENDPOINT);
    }
}

