/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.OwnerMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.OwnerMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.OwnerRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class OwnerMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, OwnerMetaBaseSQLProvider> OWNER_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new OwnerMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new OwnerMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new OwnerMetaPostgreSQLProvider());

    public static OwnerMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return OWNER_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String selectUserOwnerMetaByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return OwnerMetaSQLProviderFactory.getProvider().selectUserOwnerMetaByMetadataObjectIdAndType(metadataObjectId, metadataObjectType);
    }

    public static String selectGroupOwnerMetaByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return OwnerMetaSQLProviderFactory.getProvider().selectGroupOwnerMetaByMetadataObjectIdAndType(metadataObjectId, metadataObjectType);
    }

    public static String insertOwnerRel(@Param(value="ownerRelPO") OwnerRelPO ownerRelPO) {
        return OwnerMetaSQLProviderFactory.getProvider().insertOwnerRel(ownerRelPO);
    }

    public static String softDeleteOwnerRelByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return OwnerMetaSQLProviderFactory.getProvider().softDeleteOwnerRelByMetadataObjectIdAndType(metadataObjectId, metadataObjectType);
    }

    public static String softDeleteOwnerRelByOwnerIdAndType(@Param(value="ownerId") Long ownerId, @Param(value="ownerType") String ownerType) {
        return OwnerMetaSQLProviderFactory.getProvider().softDeleteOwnerRelByOwnerIdAndType(ownerId, ownerType);
    }

    public static String softDeleteOwnerRelByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return OwnerMetaSQLProviderFactory.getProvider().softDeleteOwnerRelByMetalakeId(metalakeId);
    }

    public static String softDeleteOwnerRelByCatalogId(@Param(value="catalogId") Long catalogId) {
        return OwnerMetaSQLProviderFactory.getProvider().softDeleteOwnerRelByCatalogId(catalogId);
    }

    public static String softDeleteOwnerRelBySchemaId(@Param(value="schemaId") Long schemaId) {
        return OwnerMetaSQLProviderFactory.getProvider().sotDeleteOwnerRelBySchemaId(schemaId);
    }

    public static String deleteOwnerMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return OwnerMetaSQLProviderFactory.getProvider().deleteOwnerMetasByLegacyTimeline(legacyTimeline, limit);
    }

    static class OwnerMetaH2Provider
    extends OwnerMetaBaseSQLProvider {
        OwnerMetaH2Provider() {
        }
    }

    static class OwnerMetaMySQLProvider
    extends OwnerMetaBaseSQLProvider {
        OwnerMetaMySQLProvider() {
        }
    }
}

