/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.push.config;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hertzbeat.push.config.PushErrorRequestWrapper;
import org.apache.hertzbeat.push.config.PushSuccessRequestWrapper;
import org.apache.hertzbeat.push.service.PushGatewayService;

public class PushPrometheusStreamReadingFilter
implements Filter {
    private final PushGatewayService pushGatewayService;
    private final Pattern pathPattern = Pattern.compile("^/api/push/prometheus/job/([a-zA-Z0-9_]*)(?:/instance/([a-zA-Z0-9_]*))?$");

    public PushPrometheusStreamReadingFilter(PushGatewayService pushGatewayService) {
        this.pushGatewayService = pushGatewayService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String uri = httpRequest.getRequestURI();
            Matcher matcher = this.pathPattern.matcher(uri);
            String job = null;
            String instance = null;
            if (matcher.matches()) {
                job = matcher.group(1);
                instance = matcher.group(2);
                boolean flag = this.pushGatewayService.pushPrometheusMetrics((InputStream)request.getInputStream(), job, instance);
                if (flag) {
                    PushSuccessRequestWrapper successRequestWrapper = new PushSuccessRequestWrapper(httpRequest, job, instance);
                    chain.doFilter((ServletRequest)successRequestWrapper, response);
                } else {
                    PushErrorRequestWrapper errorRequestWrapper = new PushErrorRequestWrapper(httpRequest, job, instance);
                    chain.doFilter((ServletRequest)errorRequestWrapper, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

