/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.manager.pojo.dto.AppCount;
import org.apache.hertzbeat.manager.pojo.dto.Dashboard;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Summary Statistics API")
@RestController
@RequestMapping(path={"/api/summary"}, produces={"application/json"})
public class SummaryController {
    @Autowired
    private MonitorService monitorService;

    @GetMapping
    @Operation(summary="Query all application category monitoring statistics", description="Query all application category monitoring statistics")
    public ResponseEntity<Message<Dashboard>> appMonitors() {
        List<AppCount> appsCount = this.monitorService.getAllAppMonitorsCount();
        Message<Dashboard> message = Message.success(new Dashboard(appsCount));
        return ResponseEntity.ok(message);
    }
}

