/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiEncoderDecoder;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.Ipmi20Ipv4SessionWrapper;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.rmcp.RmcpPacket;

public class UdpConnection {
    final String host;
    final int port;
    final SocketAddress address;
    DatagramChannel channel;
    ByteBuffer receiveBuffer = ByteBuffer.allocate(1024);

    public UdpConnection(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
        this.channel = DatagramChannel.open();
    }

    private int send(IpmiPacketContext context, IpmiPayload payload) throws IOException {
        Ipmi20Ipv4SessionWrapper wrapper = new Ipmi20Ipv4SessionWrapper();
        wrapper.setIpmiPayload(payload);
        if (context.getIpmiSession().isConnected()) {
            wrapper.setIpmiSessionId(context.getIpmiSession().getSystemSessionId());
            wrapper.setIpmiSessionSequenceNumber(context.getIpmiSession().getAuthenticatedSequenceNumber().getAndIncrement());
        }
        RmcpPacket rmcpPacket = new RmcpPacket();
        rmcpPacket.withData(wrapper);
        ByteBuffer sendBuffer = IpmiEncoderDecoder.encode(context, rmcpPacket);
        return this.channel.send(sendBuffer, this.address);
    }

    private <T extends IpmiPayload> T receive(IpmiPacketContext context, Class<T> clazz) throws IOException {
        this.receiveBuffer.clear();
        this.channel.receive(this.receiveBuffer);
        this.receiveBuffer.flip();
        RmcpPacket rmcpPacket = IpmiEncoderDecoder.decode(context, this.receiveBuffer);
        return (T)((IpmiPayload)rmcpPacket.getEncapsulated(clazz));
    }

    public <T extends IpmiPayload> T get(IpmiPacketContext context, IpmiPayload payload, Class<T> clazz) throws IOException {
        this.send(context, payload);
        return this.receive(context, clazz);
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

