/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Extern Alarm Manage API")
@RestController
public class AlertReportController {
    private static final Logger log = LoggerFactory.getLogger(AlertReportController.class);
    private final List<ExternAlertService> externAlertServiceList;

    public AlertReportController(List<ExternAlertService> externAlertServiceList) {
        this.externAlertServiceList = externAlertServiceList;
    }

    @PostMapping(value={"/api/alerts/report/{source}"})
    @Operation(summary="Api for receive external alarm information")
    public ResponseEntity<Message<Void>> receiveExternAlert(@PathVariable(value="source") String source, @RequestBody String content) {
        log.info("Receive extern alert from source: {}, content: {}", (Object)source, (Object)content);
        if (!StringUtils.hasText((String)source)) {
            source = "default";
        }
        for (ExternAlertService externAlertService : this.externAlertServiceList) {
            if (!externAlertService.supportSource().equals(source)) continue;
            try {
                externAlertService.addExternAlert(content);
                return ResponseEntity.ok((Object)Message.success((String)"Add extern alert success"));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Add extern alert failed: " + e.getMessage())));
            }
        }
        log.warn("Not support extern alert from source: {}", (Object)source);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Not support the " + source + " source alert")));
    }

    @PostMapping(value={"/api/alerts/report"})
    @Operation(summary="Api for receive default external alarm information")
    public ResponseEntity<Message<Void>> receiveDefaultExternAlert(@RequestBody String content) {
        log.info("Receive default extern alert content: {}", (Object)content);
        ExternAlertService externAlertService = this.externAlertServiceList.stream().filter(item -> "default".equals(item.supportSource())).findFirst().orElse(null);
        if (externAlertService != null) {
            try {
                externAlertService.addExternAlert(content);
                return ResponseEntity.ok((Object)Message.success((String)"Add extern alert success"));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Add extern alert failed: " + e.getMessage())));
            }
        }
        log.error("Not support default extern alert");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.success((String)"Not support the default source alert"));
    }

    @PostMapping(value={"/api/v2/alerts"})
    @Operation(summary="Api for receive external alarm information")
    public ResponseEntity<Message<Void>> receivePrometheusServerAlert(@RequestBody String content) {
        log.info("Receive prometheus server alert, content: {}", (Object)content);
        ExternAlertService externAlertService = this.externAlertServiceList.stream().filter(item -> "prometheus".equals(item.supportSource())).findFirst().orElse(null);
        if (externAlertService != null) {
            try {
                externAlertService.addExternAlert(content);
                return ResponseEntity.ok((Object)Message.success((String)"Add extern alert success"));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.fail((byte)15, (String)("Add extern alert failed: " + e.getMessage())));
            }
        }
        log.error("Not support prometheus extern alert");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)Message.success((String)"Not support the prometheus source alert"));
    }
}

