/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

public class PlcTIME
extends PlcSimpleValue<Duration> {
    public static PlcTIME of(Object value) {
        if (value instanceof Duration) {
            return new PlcTIME((Duration)value);
        }
        if (value instanceof Integer) {
            return new PlcTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        if (value instanceof Long) {
            return new PlcTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    public static PlcTIME ofMilliseconds(long milliseconds) {
        return new PlcTIME(Duration.ofMillis(milliseconds));
    }

    public PlcTIME(Duration value) {
        super(value, true);
    }

    public PlcTIME(long milliseconds) {
        super(Duration.ofMillis(milliseconds), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.TIME;
    }

    public long getMilliseconds() {
        return ((Duration)this.value).toMillis();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public int getInteger() {
        return (int)(((Duration)this.value).get(ChronoUnit.NANOS) / 1000000L);
    }

    @Override
    public long getLong() {
        return ((Duration)this.value).toMillis();
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    public String getString() {
        return ((Duration)this.value).toString();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeLong(this.getClass().getSimpleName(), 32, ((Duration)this.value).toMillis(), new WithWriterArgs[0]);
    }
}

