/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.remoting.netty;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.MessageLite;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.util.concurrent.ThreadFactory;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.support.CommonThreadPool;
import org.apache.hertzbeat.remoting.RemotingClient;
import org.apache.hertzbeat.remoting.event.NettyEventListener;
import org.apache.hertzbeat.remoting.netty.NettyClientConfig;
import org.apache.hertzbeat.remoting.netty.NettyRemotingAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingClient.class);
    private static final int DEFAULT_WORKER_THREAD_NUM = Math.min(4, Runtime.getRuntime().availableProcessors());
    private final NettyClientConfig nettyClientConfig;
    private final CommonThreadPool threadPool;
    private final Bootstrap bootstrap = new Bootstrap();
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, NettyEventListener nettyEventListener, CommonThreadPool threadPool) {
        super(nettyEventListener);
        this.nettyClientConfig = nettyClientConfig;
        this.threadPool = threadPool;
    }

    @Override
    public void start() {
        this.threadPool.execute(() -> {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setUncaughtExceptionHandler((thread, throwable) -> {
                log.error("NettyClientWorker has uncaughtException.");
                log.error(throwable.getMessage(), throwable);
            }).setDaemon(true).setNameFormat("netty-client-worker-%d").build();
            String envThreadNum = System.getProperty("hertzbeat.client.worker.thread.num");
            int workerThreadNum = envThreadNum != null ? Integer.parseInt(envThreadNum) : DEFAULT_WORKER_THREAD_NUM;
            this.workerGroup = new NioEventLoopGroup(workerThreadNum, threadFactory);
            ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    NettyRemotingClient.this.initChannel(channel);
                }
            });
            this.channel = null;
            boolean first = true;
            while (!(Thread.currentThread().isInterrupted() || !first && this.channel != null && this.channel.isActive())) {
                first = false;
                try {
                    this.channel = this.bootstrap.connect(this.nettyClientConfig.getServerHost(), this.nettyClientConfig.getServerPort()).sync().channel();
                    this.channel.closeFuture().sync();
                }
                catch (InterruptedException ignored) {
                    log.info("client shutdown now!");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e2) {
                    log.error("client connect to server error: {}. try after 10s.", (Object)e2.getMessage());
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.workerGroup.shutdownGracefully();
        });
    }

    private void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)});
        pipeline.addLast(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)ClusterMsg.Message.getDefaultInstance())});
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufEncoder()});
        pipeline.addLast(new ChannelHandler[]{new NettyClientHandler()});
    }

    @Override
    public void shutdown() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            this.workerGroup.shutdownGracefully();
            this.threadPool.destroy();
        }
        catch (Exception e) {
            log.error("netty client shutdown exception, ", (Throwable)e);
        }
    }

    @Override
    public boolean isStart() {
        return this.channel != null && this.channel.isActive();
    }

    @Override
    public void sendMsg(ClusterMsg.Message request) {
        this.sendMsgImpl(this.channel, request);
    }

    @Override
    public ClusterMsg.Message sendMsgSync(ClusterMsg.Message request, int timeoutMillis) {
        return this.sendMsgSyncImpl(this.channel, request, timeoutMillis);
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<ClusterMsg.Message> {
        NettyClientHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyRemotingClient.this.channelActive(ctx);
        }

        protected void channelRead0(ChannelHandlerContext ctx, ClusterMsg.Message msg) throws Exception {
            NettyRemotingClient.this.processReceiveMsg(ctx, msg);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            NettyRemotingClient.this.channelIdle(ctx, evt);
        }
    }
}

