/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rw;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.EP;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.enums.RWSite;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.rw.ExecuteCallBack;
import dm.jdbc.rw.RWCounter;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil2 {
    private static ILogger log = LogFactory.getLog(RWUtil2.class);
    public static final String SQL_SELECT_STANDBY = "select distinct mailIni.inst_name, mailIni.INST_IP, mailIni.INST_PORT, archIni.arch_status from  v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";
    public static final String SQL_SELECT_STANDBY2 = "select distinct mailIni.mal_inst_name, mailIni.mal_INST_HOST, mailIni.mal_INST_PORT, archIni.arch_status from v$arch_status archIni left join (select * from V$DM_MAL_INI) mailIni on archIni.arch_dest = mailIni.mal_inst_name left join V$MAL_LINK_STATUS on CTL_LINK_STATUS  = 'CONNECTED' AND DATA_LINK_STATUS = 'CONNECTED' where archIni.arch_type in ('TIMELY', 'REALTIME') AND  archIni.arch_status = 'VALID'";

    public static DmdbConnection connect(DmDriver dmDriver, DmProperties dmProperties) {
        dmProperties.setProperty(Configuration.loginMode.getName(), "1");
        DmdbConnection dmdbConnection = dmDriver.do_connect(dmProperties);
        dmdbConnection.rwInfo.rwCounter = RWCounter.getInstance(dmdbConnection, dmdbConnection.standbyCount);
        RWUtil2.connectStandby(dmdbConnection);
        return dmdbConnection;
    }

    public static void reconnect(DmdbConnection dmdbConnection) {
        if (dmdbConnection.rwInfo == null) {
            return;
        }
        RWUtil2.removeStandby(dmdbConnection);
        dmdbConnection.do_reconnect();
        dmdbConnection.rwInfo.cleanup();
        dmdbConnection.rwInfo.rwCounter = RWCounter.getInstance(dmdbConnection, dmdbConnection.standbyCount);
        RWUtil2.connectStandby(dmdbConnection);
    }

    public static void recoverStandby(DmdbConnection dmdbConnection) {
        if (dmdbConnection.do_isClosed() || RWUtil2.isStandbyAlive(dmdbConnection)) {
            return;
        }
        long l2 = System.currentTimeMillis();
        int n2 = dmdbConnection.rwStandbyRecoverTime;
        if (n2 <= 0 || l2 - dmdbConnection.rwInfo.tryRecoverTs < (long)n2) {
            return;
        }
        RWUtil2.connectStandby(dmdbConnection);
        dmdbConnection.rwInfo.tryRecoverTs = l2;
    }

    private static void connectStandby(DmdbConnection dmdbConnection) {
        EP eP = RWUtil2.chooseValidStandby(dmdbConnection);
        if (eP == null) {
            log.warn(dmdbConnection, "connStandby", "no valid standby");
            return;
        }
        try {
            DmProperties dmProperties = (DmProperties)dmdbConnection.props.clone();
            dmProperties.setProperty(Configuration.host.getName(), eP.host);
            dmProperties.setProperty(Configuration.port.getName(), String.valueOf(eP.port));
            dmProperties.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            dmProperties.setProperty(Configuration.epGroup.getName(), null);
            dmProperties.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            dmProperties.setProperty(Configuration.switchTimes.getName(), "0");
            dmdbConnection.rwInfo.connStandby = DmDriver.driver.do_connect(dmProperties);
            if (dmdbConnection.rwInfo.connStandby.svrMode != 2 || dmdbConnection.rwInfo.connStandby.svrStat != 4) {
                RWUtil2.removeStandby(dmdbConnection);
            }
        }
        catch (Throwable throwable) {
            log.warn(dmdbConnection, "connStandby", throwable.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static EP chooseValidStandby(DmdbConnection dmdbConnection) {
        EP eP;
        DmdbResultSet dmdbResultSet;
        block19: {
            Throwable throwable;
            block20: {
                block18: {
                    int n2;
                    dmdbResultSet = null;
                    throwable = null;
                    String string = "";
                    String string2 = "";
                    try {
                        if (dmdbConnection.rwSeparate == 2) {
                            String string3 = "";
                            if (dmdbConnection.epGroup != null) {
                                n2 = 0;
                                for (EP eP2 : dmdbConnection.epGroup.epList) {
                                    if (n2 != 0) {
                                        string3 = String.valueOf(string3) + ",";
                                    }
                                    string3 = String.valueOf(string3) + "'" + eP2.host + ":" + eP2.port + "'";
                                    ++n2;
                                }
                            }
                            if (StringUtil.isNotEmpty(string3)) {
                                string = " and (mailIni.INST_IP || ':'|| mailIni.INST_PORT) in (" + string3 + ")";
                                string2 = " and (mailIni.mal_INST_HOST || ':'|| mailIni.mal_INST_PORT) in (" + string3 + ")";
                            }
                        }
                        dmdbResultSet = DriverUtil.executeQuery(dmdbConnection, dmdbConnection.malini2 ? SQL_SELECT_STANDBY2 + string2 : SQL_SELECT_STANDBY + string);
                    }
                    catch (SQLException sQLException) {
                        MiscUtil.close(dmdbResultSet);
                        try {
                            dmdbResultSet = DriverUtil.executeQuery(dmdbConnection, dmdbConnection.malini2 ? SQL_SELECT_STANDBY + string : SQL_SELECT_STANDBY2 + string2);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                    }
                    try {
                        int n3;
                        int n4 = n3 = dmdbResultSet == null ? 0 : (int)dmdbResultSet.getRowCount();
                        if (n3 <= 0) break block18;
                        dmdbConnection.rwInfo.rwCounter = RWCounter.getInstance(dmdbConnection, n3);
                        n2 = 0;
                        int n5 = dmdbConnection.rwInfo.rwCounter.chooseStandbyIndex(n3);
                        while (dmdbResultSet.do_next()) {
                            if (n2 == n5) {
                                eP = new EP(dmdbResultSet.do_getString(2), dmdbResultSet.do_getInt(3));
                                break block19;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable4) {
                        MiscUtil.close(dmdbResultSet);
                        throw throwable4;
                    }
                    {
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            MiscUtil.close(dmdbResultSet);
                            break block20;
                            break;
                        }
                    }
                }
                MiscUtil.close(dmdbResultSet);
            }
            if (throwable != null) {
                DBError.throwRuntimeException("choose valid standby error!", throwable);
            }
            return null;
        }
        MiscUtil.close(dmdbResultSet);
        return eP;
    }

    public static void afterExceptionOnStandby(DmdbConnection dmdbConnection, SQLException sQLException) {
        if (sQLException.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
            RWUtil2.removeStandby(dmdbConnection);
        }
    }

    private static void removeStandby(DmdbConnection dmdbConnection) {
        try {
            if (dmdbConnection.rwInfo.connStandby != null) {
                dmdbConnection.rwInfo.connStandby.do_close();
                dmdbConnection.rwInfo.connStandby = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public static boolean isCreateStandbyStmt(DmdbStatement dmdbStatement) {
        return dmdbStatement != null && dmdbStatement.rwInfo.readOnly && RWUtil2.isStandbyAlive(dmdbStatement.connection);
    }

    public static Object execute(DmdbStatement dmdbStatement, String string, ExecuteCallBack executeCallBack) {
        DmdbStatement dmdbStatement2 = dmdbStatement.rwInfo.stmtCurrent;
        RWUtil2.recoverStandby(dmdbStatement.connection);
        RWUtil2.distribute(dmdbStatement, string);
        if (dmdbStatement2 != dmdbStatement.rwInfo.stmtCurrent) {
            dmdbStatement.rwInfo.stmtCurrent.resetParams(dmdbStatement2);
        }
        Object object = null;
        boolean bl = false;
        try {
            object = executeCallBack.execute();
            DmdbStatement dmdbStatement3 = dmdbStatement.rwInfo.stmtCurrent;
            switch (dmdbStatement3.getRetType()) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    try {
                        DmdbStatement dmdbStatement4;
                        DmdbStatement dmdbStatement5 = dmdbStatement4 = dmdbStatement3 != dmdbStatement ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
                        if (dmdbStatement4 == null) break;
                        dmdbStatement4.resetParams(dmdbStatement3);
                        executeCallBack.execute(dmdbStatement4);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 162: {
                    String string2 = StringUtil.isNotEmpty(string) ? string.trim() : (StringUtil.isNotEmpty(dmdbStatement.nativeSql) ? dmdbStatement.nativeSql.trim() : "");
                    String string3 = string2.split("[ (]", 2)[0];
                    if (string3.equalsIgnoreCase("SP_SET_PARA_VALUE") || string3.equalsIgnoreCase("SP_SET_SESSION_READONLY")) {
                        try {
                            DmdbStatement dmdbStatement6;
                            DmdbStatement dmdbStatement7 = dmdbStatement6 = dmdbStatement3 != dmdbStatement ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
                            if (dmdbStatement6 == null) break;
                            dmdbStatement6.resetParams(dmdbStatement3);
                            executeCallBack.execute(dmdbStatement6);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 160: {
                    if (dmdbStatement.connection.rwHA && dmdbStatement3 == dmdbStatement.rwInfo.stmtStandby && (dmdbStatement3.execInfo.rsDatas == null || dmdbStatement3.execInfo.rsDatas.length == 0)) {
                        bl = true;
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            if (dmdbStatement.rwInfo.stmtCurrent == dmdbStatement.rwInfo.stmtStandby) {
                RWUtil2.afterExceptionOnStandby(dmdbStatement.connection, sQLException);
                bl = true;
            }
            throw sQLException;
        }
        if (bl) {
            dmdbStatement.connection.rwInfo.toPrimary();
            dmdbStatement.rwInfo.stmtCurrent = dmdbStatement;
            dmdbStatement.resetParams(dmdbStatement.rwInfo.stmtStandby);
            return executeCallBack.execute(dmdbStatement);
        }
        return object;
    }

    public static boolean checkReadonly(DmdbStatement dmdbStatement, String string) {
        boolean bl = true;
        if (StringUtil.isNotEmpty(string) && !dmdbStatement.connection.rwIgnoreSql) {
            String string2 = string.trim();
            String string3 = string2.split(" ", 2)[0];
            bl = string3.equalsIgnoreCase("SELECT") ? dmdbStatement.resultSetConcurrency == 1007 : !string3.equalsIgnoreCase("INSERT") && !string3.equalsIgnoreCase("UPDATE") && !string3.equalsIgnoreCase("DELETE") && !string3.equalsIgnoreCase("CREATE") && !string3.equalsIgnoreCase("TRUNCATE") && !string3.equalsIgnoreCase("DROP") && !string3.equalsIgnoreCase("ALTER");
        }
        return bl;
    }

    public static RWSite distribute(DmdbStatement dmdbStatement, String string) {
        RWSite rWSite = null;
        rWSite = !RWUtil2.isStandbyAlive(dmdbStatement.connection) ? dmdbStatement.connection.rwInfo.toPrimary() : ((dmdbStatement instanceof DmdbPreparedStatement ? !dmdbStatement.rwInfo.readOnly : !RWUtil2.checkReadonly(dmdbStatement, string)) ? dmdbStatement.connection.rwInfo.toPrimary() : (dmdbStatement.connection.rwInfo.distribute == RWSite.PRIMARY && !dmdbStatement.connection.trxFinish || dmdbStatement.connection.rwInfo.distribute == RWSite.STANDBY && !dmdbStatement.connection.rwInfo.connStandby.trxFinish ? dmdbStatement.connection.rwInfo.distribute : (dmdbStatement.connection.isoLevel != 8 ? dmdbStatement.connection.rwInfo.toAny() : dmdbStatement.connection.rwInfo.toPrimary())));
        if (rWSite == RWSite.STANDBY && !RWUtil2.isStandbyStatementValid(dmdbStatement)) {
            try {
                dmdbStatement.rwInfo.stmtStandby = dmdbStatement instanceof DmdbCallableStatement ? dmdbStatement.connection.rwInfo.connStandby.do_prepareCall(dmdbStatement.nativeSql, dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability) : (dmdbStatement instanceof DmdbPreparedStatement ? dmdbStatement.connection.rwInfo.connStandby.do_prepareStatement(dmdbStatement.nativeSql, dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability) : dmdbStatement.connection.rwInfo.connStandby.do_createStatement(dmdbStatement.resultSetType, dmdbStatement.resultSetConcurrency, dmdbStatement.resultSetHoldability));
            }
            catch (Exception exception) {
                rWSite = dmdbStatement.connection.rwInfo.toPrimary();
            }
        }
        dmdbStatement.rwInfo.stmtCurrent = rWSite == RWSite.PRIMARY ? dmdbStatement : dmdbStatement.rwInfo.stmtStandby;
        return rWSite;
    }

    public static boolean isStandbyAlive(DmdbConnection dmdbConnection) {
        return dmdbConnection.rwInfo.connStandby != null && !dmdbConnection.rwInfo.connStandby.do_isClosed();
    }

    public static boolean isStandbyStatementValid(DmdbStatement dmdbStatement) {
        return dmdbStatement.rwInfo.stmtStandby != null && !dmdbStatement.rwInfo.stmtStandby.do_isClosed();
    }
}

