/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

public class PropertyUtils {
    private static final String PROCESSORS_ENV_NAME = "NACOS_COMMON_PROCESSORS";
    private static final String PROCESSORS_PROP_NAME = "nacos.common.processors";

    private PropertyUtils() {
    }

    public static String getProperty(String propertyName, String envName) {
        return System.getenv().getOrDefault(envName, System.getProperty(propertyName));
    }

    public static String getProperty(String propertyName, String envName, String defaultValue) {
        return System.getenv().getOrDefault(envName, System.getProperty(propertyName, defaultValue));
    }

    public static int getProcessorsCount() {
        int processorsCount = 0;
        String processorsCountPreSet = PropertyUtils.getProperty(PROCESSORS_PROP_NAME, PROCESSORS_ENV_NAME);
        if (processorsCountPreSet != null) {
            try {
                processorsCount = Integer.parseInt(processorsCountPreSet);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (processorsCount <= 0) {
            processorsCount = Runtime.getRuntime().availableProcessors();
        }
        return processorsCount;
    }
}

