/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty;

import com.alibaba.nacos.shaded.com.google.common.annotations.VisibleForTesting;
import com.alibaba.nacos.shaded.com.google.common.base.MoreObjects;
import com.alibaba.nacos.shaded.com.google.common.base.Preconditions;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.SettableFuture;
import com.alibaba.nacos.shaded.io.grpc.Attributes;
import com.alibaba.nacos.shaded.io.grpc.CallOptions;
import com.alibaba.nacos.shaded.io.grpc.ChannelLogger;
import com.alibaba.nacos.shaded.io.grpc.ClientStreamTracer;
import com.alibaba.nacos.shaded.io.grpc.InternalChannelz;
import com.alibaba.nacos.shaded.io.grpc.InternalLogId;
import com.alibaba.nacos.shaded.io.grpc.Metadata;
import com.alibaba.nacos.shaded.io.grpc.MethodDescriptor;
import com.alibaba.nacos.shaded.io.grpc.Status;
import com.alibaba.nacos.shaded.io.grpc.internal.ClientStream;
import com.alibaba.nacos.shaded.io.grpc.internal.ClientTransport;
import com.alibaba.nacos.shaded.io.grpc.internal.ConnectionClientTransport;
import com.alibaba.nacos.shaded.io.grpc.internal.FailingClientStream;
import com.alibaba.nacos.shaded.io.grpc.internal.GrpcUtil;
import com.alibaba.nacos.shaded.io.grpc.internal.Http2Ping;
import com.alibaba.nacos.shaded.io.grpc.internal.KeepAliveManager;
import com.alibaba.nacos.shaded.io.grpc.internal.ManagedClientTransport;
import com.alibaba.nacos.shaded.io.grpc.internal.StatsTraceContext;
import com.alibaba.nacos.shaded.io.grpc.internal.TransportTracer;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.ClientTransportLifecycleManager;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.ForcefulCloseCommand;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.GracefulCloseCommand;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyClientHandler;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyClientStream;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.SendPingCommand;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.Utils;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.grpc.netty.WriteBufferingAndExceptionHandler;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.bootstrap.Bootstrap;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.Channel;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFactory;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelFutureListener;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOption;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoop;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.handler.codec.http2.StreamBufferingEncoder;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.util.AsciiString;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import com.alibaba.nacos.shaded.javax.annotation.Nullable;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class NettyClientTransport
implements ConnectionClientTransport {
    private final InternalLogId logId;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final SocketAddress remoteAddress;
    private final ChannelFactory<? extends Channel> channelFactory;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final String authorityString;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final boolean autoFlowControl;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private KeepAliveManager keepAliveManager;
    private final long keepAliveTimeNanos;
    private final long keepAliveTimeoutNanos;
    private final boolean keepAliveWithoutCalls;
    private final AsciiString negotiationScheme;
    private final Runnable tooManyPingsRunnable;
    private NettyClientHandler handler;
    private Channel channel;
    private Status statusExplainingWhyTheChannelIsNull;
    private ClientTransportLifecycleManager lifecycleManager;
    private final TransportTracer transportTracer;
    private final Attributes eagAttributes;
    private final NettyChannelBuilder.LocalSocketPicker localSocketPicker;
    private final ChannelLogger channelLogger;
    private final boolean useGetForSafeMethods;

    NettyClientTransport(SocketAddress address, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> channelOptions, EventLoopGroup group, ProtocolNegotiator negotiator, boolean autoFlowControl, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, String authority, @Nullable String userAgent, Runnable tooManyPingsRunnable, TransportTracer transportTracer, Attributes eagAttributes, NettyChannelBuilder.LocalSocketPicker localSocketPicker, ChannelLogger channelLogger, boolean useGetForSafeMethods) {
        this.negotiator = Preconditions.checkNotNull(negotiator, "negotiator");
        this.negotiationScheme = this.negotiator.scheme();
        this.remoteAddress = Preconditions.checkNotNull(address, "address");
        this.group = Preconditions.checkNotNull(group, "group");
        this.channelFactory = channelFactory;
        this.channelOptions = Preconditions.checkNotNull(channelOptions, "channelOptions");
        this.autoFlowControl = autoFlowControl;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeNanos = keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
        this.authorityString = authority;
        this.authority = new AsciiString(authority);
        this.userAgent = new AsciiString(GrpcUtil.getGrpcUserAgent("netty", userAgent));
        this.tooManyPingsRunnable = Preconditions.checkNotNull(tooManyPingsRunnable, "tooManyPingsRunnable");
        this.transportTracer = Preconditions.checkNotNull(transportTracer, "transportTracer");
        this.eagAttributes = Preconditions.checkNotNull(eagAttributes, "eagAttributes");
        this.localSocketPicker = Preconditions.checkNotNull(localSocketPicker, "localSocketPicker");
        this.logId = InternalLogId.allocate(this.getClass(), this.remoteAddress.toString());
        this.channelLogger = Preconditions.checkNotNull(channelLogger, "channelLogger");
        this.useGetForSafeMethods = useGetForSafeMethods;
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        if (this.channel == null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull.asException());
                }
            });
            return;
        }
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed(callback, executor, s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener(failureListener);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(headers, "headers");
        if (this.channel == null) {
            return new FailingClientStream(this.statusExplainingWhyTheChannelIsNull, tracers);
        }
        StatsTraceContext statsTraceCtx = StatsTraceContext.newClientContext(tracers, this.getAttributes(), headers);
        return new NettyClientStream(new NettyClientStream.TransportState(this.handler, this.channel.eventLoop(), this.maxMessageSize, statsTraceCtx, this.transportTracer, method.getFullMethodName()){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        }, method, headers, this.channel, this.authority, this.negotiationScheme, this.userAgent, statsTraceCtx, this.transportTracer, callOptions, this.useGetForSafeMethods);
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener transportListener) {
        Object tcpUserTimeout;
        this.lifecycleManager = new ClientTransportLifecycleManager(Preconditions.checkNotNull(transportListener, "listener"));
        EventLoop eventLoop = this.group.next();
        if (this.keepAliveTimeNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), eventLoop, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
        }
        this.handler = NettyClientHandler.newHandler(this.lifecycleManager, this.keepAliveManager, this.autoFlowControl, this.flowControlWindow, this.maxHeaderListSize, GrpcUtil.STOPWATCH_SUPPLIER, this.tooManyPingsRunnable, this.transportTracer, this.eagAttributes, this.authorityString, this.channelLogger);
        ChannelHandler negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.ALLOCATOR, Utils.getByteBufAllocator(false));
        b.group(eventLoop);
        b.channelFactory(this.channelFactory);
        b.option(ChannelOption.SO_KEEPALIVE, true);
        if (this.keepAliveTimeNanos != Long.MAX_VALUE && (tcpUserTimeout = Utils.maybeGetTcpUserTimeoutOption()) != null) {
            b.option(tcpUserTimeout, (int)TimeUnit.NANOSECONDS.toMillis(this.keepAliveTimeoutNanos));
        }
        for (Map.Entry entry : this.channelOptions.entrySet()) {
            b.option((ChannelOption)entry.getKey(), entry.getValue());
        }
        WriteBufferingAndExceptionHandler bufferingHandler = new WriteBufferingAndExceptionHandler(negotiationHandler);
        b.handler(bufferingHandler);
        ChannelFuture channelFuture = b.register();
        if (channelFuture.isDone() && !channelFuture.isSuccess()) {
            this.channel = null;
            Throwable t = channelFuture.cause();
            if (t == null) {
                t = new IllegalStateException("Channel is null, but future doesn't have a cause");
            }
            this.statusExplainingWhyTheChannelIsNull = Utils.statusFromThrowable(t);
            return new Runnable(){

                @Override
                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull);
                }
            };
        }
        this.channel = channelFuture.channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.writeAndFlush(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        SocketAddress localAddress = this.localSocketPicker.createSocketAddress(this.remoteAddress, this.eagAttributes);
        if (localAddress != null) {
            this.channel.connect(this.remoteAddress, localAddress);
        } else {
            this.channel.connect(this.remoteAddress);
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportStarted();
        }
        return null;
    }

    @Override
    public void shutdown(Status reason) {
        if (this.channel == null) {
            return;
        }
        if (this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(reason), true);
        }
    }

    @Override
    public void shutdownNow(final Status reason) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new Runnable(){

                @Override
                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyShutdown(reason);
                    NettyClientTransport.this.channel.write(new ForcefulCloseCommand(reason));
                }
            }, true);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("logId", this.logId.getId()).add("remoteAddress", this.remoteAddress).add("channel", this.channel).toString();
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    @Override
    public Attributes getAttributes() {
        return this.handler.getAttributes();
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        final SettableFuture<InternalChannelz.SocketStats> result = SettableFuture.create();
        if (this.channel.eventLoop().inEventLoop()) {
            result.set(this.getStatsHelper(this.channel));
            return result;
        }
        this.channel.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                result.set(NettyClientTransport.this.getStatsHelper(NettyClientTransport.this.channel));
            }
        }).addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setException(future.cause());
                }
            }
        });
        return result;
    }

    private InternalChannelz.SocketStats getStatsHelper(Channel ch) {
        assert (ch.eventLoop().inEventLoop());
        return new InternalChannelz.SocketStats(this.transportTracer.getStats(), this.channel.localAddress(), this.channel.remoteAddress(), Utils.getSocketOptions(ch), this.handler == null ? null : this.handler.getSecurityInfo());
    }

    @VisibleForTesting
    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    KeepAliveManager keepAliveManager() {
        return this.keepAliveManager;
    }

    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException || t instanceof StreamBufferingEncoder.Http2ChannelClosedException) {
            Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
            if (shutdownStatus == null) {
                return Status.UNKNOWN.withDescription("Channel closed but for unknown reason").withCause(new ClosedChannelException().initCause(t));
            }
            return shutdownStatus;
        }
        return Utils.statusFromThrowable(t);
    }
}

