/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem;

import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.HDFSInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.LocalFSInputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.HDFSOutputFactory;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.LocalFSOutputFactory;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.HDFSFactory;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.LocalFSFactory;

public class FSFactoryProducer {
    private static FSType fSType = TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs();
    private static FSFactory fsFactory;
    private static FileInputFactory fileInputFactory;
    private static FileOutputFactory fileOutputFactory;

    public static FSFactory getFSFactory() {
        return fsFactory;
    }

    public static FileInputFactory getFileInputFactory() {
        return fileInputFactory;
    }

    public static FileOutputFactory getFileOutputFactory() {
        return fileOutputFactory;
    }

    static {
        if (fSType.equals((Object)FSType.HDFS)) {
            fsFactory = new HDFSFactory();
            fileInputFactory = new HDFSInputFactory();
            fileOutputFactory = new HDFSOutputFactory();
        } else {
            fsFactory = new LocalFSFactory();
            fileInputFactory = new LocalFSInputFactory();
            fileOutputFactory = new LocalFSOutputFactory();
        }
    }
}

